<?php
if ($requestUri == "search/pool") {
	$data = $_POST;
	$filter = [$data['filterby'] => ['$regex' => ".*{$data['filtervalue']}.*"]];
	$rows =  $db->queryMDB('unp.unp_pools', $filter);
	$rows = json_encode(iterator_to_array($rows));
	$result = $rows;
} elseif ($requestUri == "search/school") {
	$data = $_POST;
	$filter = changeStringToInt($data);
	$rows =  $db->queryMDB('unp.unp_schools', $filter);
	$rows = json_encode(iterator_to_array($rows));
	$result = $rows;
} elseif ($requestUri == "search/lesson") {
	$data = $_POST;
	$filter = [$data['filterby'] => ['$regex' => ".*{$data['filtervalue']}.*"]];
	$rows =  $db->queryMDB('unp.unp_lessons', $filter);
	$rows = json_encode(iterator_to_array($rows));
	$result = $rows;
} elseif ($requestUri == "search/lesson2") {
	$data = $_POST;
	$filter = changeStringToInt($data);
	if (isset($filter['poolID']) && isset($filter['lessonDate'])) {
		$temp['lessonDateUtc'] = new MongoDB\BSON\UTCDateTime(strtotime($filter['lessonDate']) * 1000);
		$temp['lessonDateUtc2'] = new MongoDB\BSON\UTCDateTime(strtotime($filter['lessonDate'] . " +1 week") * 1000);
		$newFilter['poolID'] = $filter['poolID'];
		$newFilter['lessonDateUtc'] =  ['$gte' => $temp['lessonDateUtc'], '$lte' => $temp['lessonDateUtc2']];
		$rows =  $db->queryMDB('unp.unp_LessonsClass', $newFilter);
	} else {
		$rows =  $db->queryMDB('unp.unp_LessonsClass', $filter);
	}
	$rows = json_encode(iterator_to_array($rows));
	$result = $rows;
} elseif ($requestUri == "search/instructor") {
	$data = $_POST;
	if (isset($data['filterby'])) {
		$filter = [$data['filterby'] => ['$regex' => ".*{$data['filtervalue']}.*"]];
	} else {
		$filter = $data;
		$filter = changeStringToInt($filter);
	}
	$rows =  $db->queryMDB('unp.unp_instructor', $filter);
	$rows = json_encode(iterator_to_array($rows));
	$result = $rows;
} elseif ($requestUri == "search/poolinstructor") {
	$data = $_POST;
	$filter = [$data['filterby'] => (int)$data['filtervalue']];
	$rows =  $db->queryMDB('unp.unp_PoolsInstructors', $filter);
	$rows = json_encode(iterator_to_array($rows));
	//print_r($filter);
	$result = $rows;
} else if ($requestUri == "search/lesson2") {
	$filter = $_POST;
	//print_r($filter);
	if (isset($filter['lessonID'])) {
		$filter['lessonID'] = (int)$filter['lessonID'];
	} else if (isset($filter['classID'])) {
		$filter['classID'] = (int)$filter['classID'];
	}
	$rows = $db->queryMDB('unp.unp_lessons', $filter);
	$rows = iterator_to_array($rows);
	$result = json_encode($rows);
} elseif ($requestUri == "search/instructorclass") {
	$data = $_POST;
	$data = changeStringToInt($data);
	$limit = (isset($data['limit'])) ? $data['limit'] : 0;
	//$orderby = (isset($data['orderby']))?$data['orderby']:0;
	unset($data['limit']);
	if (isset($data['lessonDateUtc'])) {
		$data['lessonDateUtc'] = new MongoDB\BSON\UTCDateTime(strtotime($data['lessonDateUtc']) * 1000);
		$data['lessonDateUtc'] =  ['$gte' => $data['lessonDateUtc']];
	}
	$filter = $data;
	//print_r($filter);
	$rows =  $db->queryMDB('unp.unp_InstructorClass', $filter, ['limit' => $limit, 'sort' => ['lessonDateUtc' => 1]]);
	//print_r($rows);
	$rows = json_encode(iterator_to_array($rows));
	//echo "</br>";
	//print_r($rows);
	//print_r($rows);
	$result = $rows;
} elseif ($requestUri == "search/instructorclass/v2") {
	$data = $_POST;
	$data = changeStringToInt($data);
	$limit = (isset($data['limit'])) ? $data['limit'] : 0;
	//$orderby = (isset($data['orderby']))?$data['orderby']:0;
	unset($data['limit']);
	/*if (isset($data['lessonDateUtc'])) {
		//$data['lessonDateUtc'] = new MongoDB\BSON\UTCDateTime(strtotime($data['lessonDateUtc']) * 1000);
		//print_r($data['lessonDateUtc']);
		//$data['lessonDateUtc'] =  ['$gte' => $data['lessonDateUtc']];
	}*/
	$filter = $data;
	print_r($filter);
	$rows =  $db->queryMDB('unp.unp_lessonsWithDate', $filter, ['limit' => $limit, 'sort' => ['lessonCount' => 1]]);
	//print_r($rows);
	$rows = json_encode(iterator_to_array($rows));
	//echo "</br>";
	//print_r($rows);
	//print_r($rows);
	$result = $rows;
} else if ($requestUri == "search/student/status") {
	$filter = $_POST;
	$filter = changeStringToInt($filter);
	$rows = $db->queryMDB('unp.unp_studentStatus', $filter, ['sort' => ['lessonDate' => -1, 'lessonID' => -1]]);
	$rows = iterator_to_array($rows);
	$result = json_encode($rows);
} else if ($requestUri == "search/global") {
	$query = $_POST;
	$query = (array)changeStringToInt($query);
	$final = [];
	$structures = [
		[
			'name' => 'schools',
			'db' => 'unp_schools',
			'col' => 'schoolName',
			'id' => 'schoolID',
			'url' => '/school/school?schoolid='
		], [
			'name' => 'classes',
			'db' => 'unp_class',
			'col' => 'className',
			'id' => 'classID',
			'url' => '/class/class?classid='
		], [
			'name' => 'students',
			'db' => 'unp_students',
			'col' => 'name',
			'id' => 'healthID',
			'url' => '/student/student?studentid='
		], [
			'name' => 'pools',
			'db' => 'unp_pools',
			'col' => 'poolName',
			'id' => 'poolID',
			'url' => '/pool/pool?poolid='
		]
	];
	if (isset($query['q'])) {
		foreach ($structures as $s) {
			$filter = [];
			$regex = new MongoDB\BSON\Regex($query['q'], 'i');
			$filter[$s['col']] = $regex;
			$s['sid'] = "$" . strval($s['id']);
			if ($s["name"] == "students") {
				$cmd = [
					[
						'$match' => $filter
					], [
						'$lookup' => [
							'from' => "unp_class",
							'let' => ['c' => '$classID'],
							'pipeline' => [
								[
									'$match' => [
										'$expr' => [
											'$eq' => ['$classID', '$$c']
										]
									]
								], [
									'$project' => [
										'_id' => 0,
										'className' => 1,
										'schoolID' => 1,
									]
								]
							],
							'as' => 'class'
						]
					], [
						'$unwind' => ['path' => '$class']
					], [
						'$lookup' => [
							'from' => "unp_schools",
							'let' => ['s' => '$class.schoolID'],
							'pipeline' => [
								[
									'$match' => [
										'$expr' => [
											'$eq' => ['$schoolID', '$$s']
										]
									]
								], [
									'$project' => [
										'_id' => 0,
										'schoolName' => 1
									]
								]
							],
							'as' => 'school'
						]
					], [
						'$unwind' => ['path' => '$school']
					], [
						'$project' => [
							'_id' => 0,
							$s['col'] => "$" . $s['col'],
							$s['id'] => "$" . $s['id'],
							'url' => [
								'$concat' => [
									$s['url'], ['$toString' => '$studentID']
								]
							],
							'motherName' => '$motherName',
							'class' => '$class',
							'school' => '$school'
						]
					]
				];
			} else {
				if (isset($query['pool'])) {
					$filter['poolID'] = $query['pool'];
				}
				$cmd = [
					[
						'$match' => $filter
					],
					[
						'$project' => [
							'_id' => 0,
							$s['col'] => "$" . $s['col'],
							$s['id'] => "$" . $s['id'],
							'url' => [
								'$concat' => [
									$s['url'], ['$toString' => $s['sid']]
								]
							]
						]
					]
				];
			}
			$rows = $db->queryMDBV3('unp.' . $s['db'], [], [], $cmd);
			$final[$s['name']] = $rows->toArray();
		}
	}
	$result = json_encode($final);
} else if ($requestUri == "search/global/users") {
	$query = $_POST;
	$query = (array)changeStringToInt($query);
	$filter = [];
	if (isset($query['q'])) {
		$filter['lastName'] = new MongoDB\BSON\Regex($query['q'], 'i');
	}
	$cmd = [
		'$project' => [
			'_id' => 0,
			'instructorID' => 1,
			'lastName' => 1,
			'firstName' => 1,
		]
	];
	$rows = $db->queryMDB('unp.unp_user', $filter);
	$rows = iterator_to_array($rows);
	$temp = [];
	foreach($rows as $r){
		$temp[]=[
			'url'=>"/users/user?userid={$r->userID}",
			"name"=>"{$r->lastName} {$r->firstName}"
		];
	}
	$result = json_encode($temp);
} else if ($requestUri == "search/global/instructor") {
	$query = $_POST;
	$query = (array)changeStringToInt($query);
	$filter = [];
	if (isset($query['q'])) {
		$filter['lastName'] = new MongoDB\BSON\Regex($query['q'], 'i');
	}
	$cmd = [
		'$project' => [
			'_id' => 0,
			'userID' => 1,
			'lastName' => 1,
			'firstName' => 1,
		]
	];
	$rows = $db->queryMDB('unp.unp_instructor', $filter, [], $cmd);
	$rows = iterator_to_array($rows);
	$temp = [];
	foreach($rows as $r){
		$temp[]=[
			'url'=>"/instructor/instructor?instructorid={$r->userID}",
			"name"=>"{$r->lastName} {$r->firstName}"
		];
	}
	$result = json_encode($temp);
}
