<?php
class MDB{
    private $con;
    function __construct(){
        $this->connectMDB();
    }
    private function connectMDB(){
        $this->con = new MongoDB\Driver\Manager("mongodb://localhost:27017");
    }
    public function queryMDB($target, $filter, $options = null, $command = null)
    {

        if ($filter != null) {
            $qry = new MongoDB\Driver\Query($filter, $options);
        } else {
            $qry = new MongoDB\Driver\Query([], $options);
        }

        $response = $this->con->executeQuery($target, $qry);
        $cmd_target = explode(".", $target);
        $cmd_db = $cmd_target[0];
        $cmd_target = $cmd_target[1];
        if ($command != null) {
            $cmd_filter = ($filter != []) ? $filter : null;
            //$cmd = [['$match'=>$cmd_filter],$command];
            foreach ($command as $comkey => $com) {
                $cmd[] = [$comkey => $com];
            }
            $command = $cmd;
            //var_dump($cmd_filter);
            if ($cmd_filter != null) {
                $cmd_match = ['$match' => $cmd_filter];
                array_unshift($command, $cmd_match);
            }
            //print_r($command);
            $command = new MongoDB\Driver\Command([
                'aggregate' => $cmd_target,
                'pipeline' => $command,
                'cursor' => new stdClass,
                'collation'=>[
                    'locale'=>'hu'
                ]
                
            ]);
            //print_r($command);
            $response = $this->con->executeCommand($cmd_db, $command);

            //print_r(iterator_to_array($response));
        }
        //print_r($filter);
        //print_r($response);
        return $response;
    }
    public function queryMDBV3($target, $filter, $options = null, $command = null, $filter2 = null)
    {
        //ini_set('memory_limit', '2048M');
        if ($filter != null) {
            $qry = new MongoDB\Driver\Query($filter, $options);
        } else {
            $qry = new MongoDB\Driver\Query([], $options);
        }
        $readPreference = new MongoDB\Driver\ReadPreference(MongoDB\Driver\ReadPreference::RP_PRIMARY);
        $response = $this->con->executeQuery($target, $qry, $readPreference);
        $cmd_target = explode(".", $target);
        $cmd_db = $cmd_target[0];
        $cmd_target = $cmd_target[1];
        if ($command != null) {
            if (is_array($command)) {
                $cursor = new stdClass;
                $toSend = [];
                foreach ($command as $c) {
                    $toSend[] = $c;
                    
                }
                $command = new MongoDB\Driver\Command([
                    'aggregate' => $cmd_target,
                    'pipeline' => $toSend,
                    'cursor' => new stdClass,
                    'collation'=>[
                        'locale'=>'hu'
                    ]
                ]);

                //print_r(json_encode($toSend));
                $response = $this->con->executeCommand($cmd_db, $command);
            } else {
                $command = new MongoDB\Driver\Command([
                    'aggregate' => $cmd_target,
                    'pipeline' => $command,
                    'cursor' => new stdClass,
                    'collation'=>[
                        'locale'=>'hu'
                    ]
                ]);

                //print_r($command);
                $response = $this->con->executeCommand($cmd_db, $command);
            }
            //print_r(iterator_to_array($response));
        }
        //print_r($filter);
        //print_r($response);
        return $response;
    }
    public function sendMDB($db,$target,$data){
        $bulk = new MongoDB\Driver\BulkWrite;
        $insertOneResult = $data;
        $bulk->insert($insertOneResult);
        $results = $this->con->executeBulkWrite("{$db}.{$target}",$bulk);
        return $results->getUpsertedIds();
    }
    public function removeMDB($db,$target,$data){
        $bulk = new MongoDB\Driver\BulkWrite;
        $data = (array) $data;
        $insertOneResult = changeStringToInt($data);
        $insertOneResult = (object) $insertOneResult;
        $bulk->delete($insertOneResult);
        $results = $this->con->executeBulkWrite("{$db}.{$target}",$bulk);
        return $results->getDeletedCount();
    }
    public function updateMDB($db,$target,$filter,$data, $upsert = false)
    {
        //return json_encode($data);
        $bulk = new MongoDB\Driver\BulkWrite;
        $bulk->update(
            $filter,
            ['$set' => $data],
            ['multi' => false, 'upsert' => $upsert]
        );
        $results = $this->con->executeBulkWrite("{$db}.{$target}", $bulk);
        //print_r($results);
        return $results;
    }
    public function enData($input){
		$Method = "AES-128-CBC"; 
		$Key = "UPCCW5TABQVZ2G5B54X6SQ6GXY1G3Q0O";
		$InititalVector = "OZQN93KBHWI2MEVQ";
		$RequestData = $input;
		$Request = openssl_encrypt(base64_encode($RequestData),$Method, $Key, 0, $InititalVector);
		return $Request;
	}
	public function deData($output){
        //echo $output;
		$Method = "AES-128-CBC"; 
		$Key = "UPCCW5TABQVZ2G5B54X6SQ6GXY1G3Q0O";
		$InititalVector = "OZQN93KBHWI2MEVQ";
		$RequestData = $output;
        $Request = base64_decode(openssl_decrypt($RequestData, $Method, $Key, 0, $InititalVector));
        //print_r($Request. "||||". $RequestData."||||");
		return $Request;
	}
}