<?php
class MDB
{
    private $con;
    function __construct()
    {
        $response = $this->connectMDB();
        return $response;
    }
    private function connectMDB()
    {
        $this->con = new MongoDB\Driver\Manager("mongodb://localhost:27017");
        try {
            // Code that may throw an Exception or Error.
            $test = $this->con->executeCommand('test', new MongoDB\Driver\Command(['ping' => 1]));
        } catch (Throwable $t) {
            return false;
            // Executed only in PHP 7, will not match in PHP 5
        }
        return true;
    }
    public function testMDB()
    {
        $this->con = new MongoDB\Driver\Manager("mongodb://localhost:27017");
        try {
            // Code that may throw an Exception or Error.
            $test = $this->con->executeCommand('test', new MongoDB\Driver\Command(['ping' => 1]));
        } catch (Throwable $t) {
            return false;
            // Executed only in PHP 7, will not match in PHP 5
        }
        return true;
    }
    private function fatal_handler()
    {
        $errfile = "unknown file";
        $errstr  = "shutdown";
        $errno   = E_CORE_ERROR;
        $errline = 0;

        $error = error_get_last();

        print_r($error);
    }
    public function queryMDB($target, $filter = [], $options = null, $command = null)
    {

        if ($filter != null) {
            $qry = new MongoDB\Driver\Query($filter, $options);
        } else {
            $qry = new MongoDB\Driver\Query([], $options);
        }

        $response = $this->con->executeQuery($target, $qry);
        $cmd_target = explode(".", $target);
        $cmd_target = $cmd_target[1];
        if ($command != null) {
            $cmd_filter = ($filter != []) ? $filter : null;
            //$cmd = [['$match'=>$cmd_filter],$command];
            foreach ($command as $comkey => $com) {
                $cmd[] = [$comkey => $com];
            }
            $command = $cmd;
            //var_dump($cmd_filter);
            if ($cmd_filter != null) {
                $cmd_match = ['$match' => $cmd_filter];
                array_unshift($command, $cmd_match);
            }
            //print_r($command);
            $command = new MongoDB\Driver\Command([
                'aggregate' => $cmd_target,
                'pipeline' => $command,
                'cursor' => new stdClass,
            ]);

            //print_r($command);
            $response = $this->con->executeCommand('attend', $command);
        }
        //print_r($filter);
        //print_r($response);
        return $response;
    }
    public function queryMDBV3($target, $filter, $options = null, $command = null, $filter2 = null)
    {
        //ini_set('memory_limit', '2048M');
        if ($filter != null) {
            $qry = new MongoDB\Driver\Query($filter, $options);
        } else {
            $qry = new MongoDB\Driver\Query([], $options);
        }
        $readPreference = new MongoDB\Driver\ReadPreference(MongoDB\Driver\ReadPreference::RP_PRIMARY);
        $response = $this->con->executeQuery($target, $qry, $readPreference);
        $cmd_target = explode(".", $target);
        $cmd_db = $cmd_target[0];
        $cmd_target = $cmd_target[1];
        if ($command != null) {
            if (is_array($command)) {
                $cursor = new stdClass;
                $toSend = [];
                foreach ($command as $c) {
                    $toSend[] = $c;
                }
                $command = new MongoDB\Driver\Command([
                    'aggregate' => $cmd_target,
                    'pipeline' => $toSend,
                    'cursor' => new stdClass,
                ]);

                //print_r(json_encode($toSend));
                $response = $this->con->executeCommand($cmd_db, $command);
            } else {
                $command = new MongoDB\Driver\Command([
                    'aggregate' => $cmd_target,
                    'pipeline' => $command,
                    'cursor' => new stdClass,
                ]);

                //print_r($command);
                $response = $this->con->executeCommand($cmd_db, $command);
            }
            //print_r(iterator_to_array($response));
        }
        //print_r($filter);
        //print_r($response);
        return $response;
    }
    public function sendMDB($target, $data)
    {
        $bulk = new MongoDB\Driver\BulkWrite;
        $insertOneResult = $data;
        $bulk->insert($insertOneResult);
        $results = $this->con->executeBulkWrite("{$target}", $bulk);
        return $results->getUpsertedIds();
    }
    public function removeMDB($target, $data)
    {
        $bulk = new MongoDB\Driver\BulkWrite;
        $data = (array) $data;
        $insertOneResult = changeStringToInt($data);
        $insertOneResult = (object) $insertOneResult;
        $bulk->delete($insertOneResult);
        $results = $this->con->executeBulkWrite("{$target}", $bulk);
        return $results->getDeletedCount();
    }
    public function sendManyMDB($target, $data)
    {
        $bulk = new MongoDB\Driver\BulkWrite;
        $insertOneResult = $data;
        foreach ($insertOneResult as $subdata) {
            $bulk->insert($subdata);
        }
        $results = $this->con->executeBulkWrite("{$target}", $bulk);
        return $results->getUpsertedIds();
    }
    public function updateMDB($target, $filter, $data)
    {
        //return json_encode($data);
        $bulk = new MongoDB\Driver\BulkWrite;
        $bulk->update(
            $filter,
            ['$set' => $data],
            ['multi' => false]
        );
        $results = $this->con->executeBulkWrite("{$target}", $bulk);
        //print_r($results);
        return $results;
    }
    public function enData($input)
    {
        $Method = "AES-128-CBC";
        $Key = "UPCCW5TABQVZ2G5B54X6SQ6GXY1G3Q0O";
        $InititalVector = "OZQN93KBHWI2MEVQ";
        $RequestData = $input;
        $Request = openssl_encrypt(base64_encode($RequestData), $Method, $Key, 0, $InititalVector);
        return $Request;
    }
    public function deData($output)
    {
        //echo $output;
        $Method = "AES-128-CBC";
        $Key = "UPCCW5TABQVZ2G5B54X6SQ6GXY1G3Q0O";
        $InititalVector = "OZQN93KBHWI2MEVQ";
        $RequestData = $output;
        $Request = base64_decode(openssl_decrypt($RequestData, $Method, $Key, 0, $InititalVector));
        //print_r($Request. "||||". $RequestData."||||");
        return $Request;
    }
    public function isValidHasAccess($token, $access = 0)
    {
        $filter = ['token' => $token];
        $request = $this->queryMDB("attend.users", $filter);
        $request = iterator_to_array($request);
        if ($request != [] && isset($request[0]->id) && isset($request[0]->accesslevel)) {
            if ($access != 0 && $access >= $request[0]->accesslevel) {
                return ['user' => $request[0]->id, 'accesslevel' => $request[0]->accesslevel];
            } else {
                return false;
            }
        }
        return false;
    }
}
