<?php
$requesturl = explode("/", $_SERVER['REQUEST_URI']);
if (strpos($requesturl[2], "?"))
    $requesturl[2] = substr($requesturl[2], 0, strpos($requesturl[2], "?"));
$status = substr($requesturl[2], 11, 12);
$filter = ["status" => $status];
if (isset($_GET['filter'])) {
    $filter['filter'] = $_GET['filter'];
}
//echo json_encode($filter);
$result = $auth->getApiDataFilter("v2/get/orders/status", $filter);
//print_r($result);
?>
<div class="row">
    <div class="col-12">
        <div class="card bg-transparent">
            <div class="card-body">
                <?php
                $total = 0;
                if (!isset($result->errorcode)) {
                    foreach ($result as $r) {
                        $total = $total + $r->total;
                    }
                }
                ?>
                <div class="card-body">
                <h5>Össz. érték: <?php echo attendNum($total) . " Ft"; ?></h5>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <input type="text" class="form-control filterSearch" placeholder="Gyors szűrés ...">
                </div>
            </div>
        </div>
        <div class="row">
            <?php
            if (!isset($result->errorcode)) :
                foreach ($result as $o) : ?>
                    <div class="orderitem" data-filter-productName="<?php echo $o->productName ?>" data-filter-companyName="<?php echo $o->orderhead->companyName ?>">
                        <div class="col-12" data-id="<?php echo $o->id ?>" data-orderhead="<?php echo $o->orderhead->id ?>">
                            <?php
                            //print_r($o);
                            ?>
                            <div class="card">
                                <div class="card-header" style="padding:0.25rem 20px 0.25rem 20px">
                                    <div class="row">
                                        <div class="col-lg-2 col-sm-4">
                                            <h7><?php echo "#PASS-{$o->orderhead->id}" ?></h7>
                                        </div>
                                        <div class="col-lg-6 col-sm-8">
                                            <h7><?php echo $o->orderhead->companyName ?></h7> | <small><?php echo (isset($o->customer->contactName)) ? $o->customer->contactName . " " : 'Nincs: '; ?><?php echo (isset($o->customer->contactTel)) ? "<a href=\"tel:{$o->customer->contactTel}\">{$o->customer->contactTel}</a>" : ''; ?></small>
                                            <p style="margin:0px">Szállítás dátuma:<?php echo $o->delivery ?></p>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 text-right">
                                            <a class="btn btn-primary btn-sm" href="<?php echo SITEURL ?>/orders/order/orderview?id=<?php echo $o->orderhead->id ?>">
                                                <i class="fas fa-folder">
                                                </i>
                                                Nézet
                                            </a>
                                            <a class="btn btn-info btn-sm" href="<?php echo SITEURL ?>/orders/order/orderedit?id=<?php echo $o->orderhead->id ?>">
                                                <i class="fas fa-pencil-alt">
                                                </i>
                                                Szerkesztés
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body" style="padding:5px 20px 5px 20px">
                                    <div class="row">
                                        <div class="col-lg-2 col-sm-12">
                                            <strong><?php echo $o->productName ?></strong>
                                        </div>
                                        <div class="col-lg-2 col-sm-12">
                                            <?php echo attendNum($o->total) . " Ft" ?>
                                        </div>
                                        <?php
                                        //print_r($o);
                                        ?>
                                        <div class="col-lg-3">Számla sorszám:<input class="form-control invoiceNum" type="text" data-type="invoiceNum" placeholder="Számla sorszám" value="<?php echo (isset($o->invoiceNum)) ? $o->invoiceNum : '' ?>"></div>
                                        <div class="col-lg-2">Számla kelte.:<input class="form-control invoiceDate" type="text" data-type="invoiceDate" placeholder="Számla kelte" value="<?php echo (isset($o->invoiceDate)) ? $o->invoiceDate : '' ?>"></div>
                                        <div class="col-lg-3">Trans-Pack azonosító:<input class="form-control ekaer" type="text" data-type="ekaer" placeholder="Trans-Pack" value="<?php echo (isset($o->ekaer)) ? $o->ekaer : '' ?>"></div>
                                        <div class="col-lg-3">Megrendelés száma.:<input class="form-control ordernum" type="text" data-type="ordernum" placeholder="Megrendelés szám" value="<?php echo (isset($o->ordernum)) ? $o->ordernum : '' ?>"></div>
                                        <div class="col-lg-3">
                                            Státusz:
                                            <select class="form-control status" type="number" data-type="status">
                                                <?php echo generateStatusSelect($o->status) ?>
                                            </select>
                                        </div>
                                        <div class="col-lg-2">Szállítás dátuma:<input class="form-control delivery" type="text" data-type="delivery" placeholder="Szállítási idő" value="<?php echo (isset($o->delivery)) ? $o->delivery : '' ?>"></div>
                                        <div class="col-lg-2">Szállítás fix.:<input class="form-control isfix" type="checkbox" data-type="isfix" placeholder="Szállítás fix" <?php echo (isset($o->isfix) && $o->isfix == "true") ? "checked" : '' ?>></div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="button" class="btn btn-block bg-gradient-success btn-sm savedata" data-status="<?php echo $o->status ?>">Mentés</button>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php endforeach;
            endif; ?>
        </div>
        <?php
        addJS("status.js?1.04");
        ?>