<?php
$filter = ['id' => $_GET['id']];
$order = $auth->getApiDataFilter("get/orders", $filter);
$order = $order[0];
$editable = true;
foreach ($order->body as $b) {
    if ($b->status != 0)
        $editable = false;
}
if ($editable || $user->accesslevel == 0) :
?>
    <div class="row">
        <div class="col-12 text-center">
            <div class="card">
                <button type="button" class="btn btn-block bg-gradient-success btn-lg savedata">Mentés</button>
            </div>
        </div>
    </div>
    <form id="sendForm" class="row w-100" method="POST">
        <div class="col-lg-4 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4>Partner kiválasztása</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 div-sm-6">
                            <h6>Megrendelő</h6>
                        </div>
                        <div class="col-lg-8 div-sm-6">
                            <strong><?php echo $order->customer->companyName ?></strong>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-lg-4 div-sm-6">
                            <h6>Megjegyzés</h6>
                        </div>
                        <div class="col-lg-8 div-sm-6">
                            <textarea class="orderComment form-control"><?php echo (isset($order->orderComment)) ? $order->orderComment : ''; ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-sm-12">
            <div class="card customerParameters">
                <div class="card-header">
                    <h4>Megrendelés paraméterei</h4>
                </div>
                <div class="card-body">
                    <div>
                        <h5>Számlázási adatok:</h5>
                        <?php
                        $tempCustomer = $auth->getApiDataFilter("get/partner/short", ['id' => $order->customer->id]);
                        $tempCustomer = $tempCustomer[0];
                        $customer = $tempCustomer;
                        ?>
                        <div><?php echo $customer->companyName ?></div>
                        <div><?php echo $customer->companyZip . " " . $customer->companyCity . ", " . $customer->companyAdressLocation ?></div>
                        <div><?php echo (isset($customer->companyVat)) ? $customer->companyVat : 'Nincs megadva Adószám' ?> </div>
                        <div><?php echo (isset($customer->companyVatEU)) ? $customer->companyVatEU : 'Nincs megadva EU adószám' ?> </div>
                        <div><?php echo (isset($order->total)) ? "Összesen: " . $order->total . " Ft" : '' ?> </div>
                    </div>
                    <?php if ($customer->companyTLocation2 != "") : ?>
                        <hr>
                        <div>
                            <h5>Szállítási adatok:</h5>
                            <div><?php echo $customer->companyLocationZip . " " . $customer->companyLocationCity . ", " . $customer->companyTLocation2 ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if ($customer->companyPostalLocation2 != "") : ?>
                        <hr>
                        <div>
                            <h5>Postázási adatok:</h5>
                            <div><?php echo $customer->companyPostalZip . " " . $customer->companyPostalCity . ", " . $customer->companyPostalLocation2 ?></div>
                        </div>
                    <?php endif; ?>
                    <hr>
                    <div>
                        <h5>Kapcsolattartás:</h5>
                        <?php
                            $full = $auth->getApiDataFilter("get/partner", ['id' => $order->customer->id]);
                            $full = (isset($full[0]))?$full[0]:[];
                        ?>
                        <div><?php echo (isset($full->contactName))?$full->contactName:''?></div>
                        <div><?php echo (isset($full->contactTel))?"<a href=\"tel:{$full->contactTel}\">{$full->contactTel}</a>":''?></div>
                        <div><?php echo (isset($full->contactEmail))?"<a href=\"mailto:{$full->contactEmail}\">{$full->contactEmail}</a>":''?></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4>Megrendelés egyéb</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-4">
                            Értékesítő</br>
                            <small>XXX</small>
                        </div>
                        <div class="col-8">
                            <?php
                            if ($user->accesslevel <= 1) {
                                $out =  "<select class=\"select2 salesPerson\" name=\"salesPerson\">";
                                $users = $auth->getApiData("get/users");
                                foreach ($users as $u) {
                                    $selected = (isset($order->salesPerson) && $u->id == $order->salesPerson) ? 'selected' : '';
                                    $out .= "<option value=\"{$u->id}\" {$selected}>{$u->lastName} {$u->firstName}</option>";
                                }
                                $out .= "</select>";
                                echo $out;
                            } else {
                                if (isset($order->salesPersonName) && $order->salesPersonName != null) {
                                    echo $order->salesPersonName;
                                }
                            }
                            ?>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-4">
                            Fizetési határidő:</br>
                        </div>
                        <div class="col-8">
                            <input class="paymentDueDate datepicker form-control" type="text" value="<?php echo (isset($order->paymentDueDate))?$order->paymentDueDate:date("Y-m-d",strtotime("Now"));?>">
                        </div>
                    </div>
                    <hr>
                    <?php
                    if ($user->accesslevel < 2) {
                        if(in_array($user->id,[0,2,3])){
                    ?>
                        <div class="row">
                            <div class="col-4">
                                Engedélyezés</br>
                                <small><?php
                                        if ($order->orderAcceptedBy != null) {
                                            echo $order->orderAcceptedBy;
                                        }
                                        ?></small>
                            </div>
                            <div class="col-8">
                                <select class="form-control orderAccept">
                                    <option value="0" <?php echo (isset($order->orderAccept) && $order->orderAccept == 0) ? "selected" : '' ?>>Nincs</option>
                                    <option value="1" <?php echo (isset($order->orderAccept) && $order->orderAccept == 1) ? "selected" : '' ?>>Elutasítva</option>
                                    <option value="2" <?php echo (isset($order->orderAccept) && $order->orderAccept == 2) ? "selected" : '' ?>>Engedélyezve</option>
                                </select>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-4">
                                Fizetési állapot</br>
                                <small>XXX</small>
                            </div>
                            <div class="col-8">
                                <select class="form-control orderStatus">
                                    <option value="0" <?php echo (isset($order->orderStatus) && $order->orderStatus == 0) ? "selected" : '' ?>>Nincs</option>
                                    <option value="1" <?php echo (isset($order->orderStatus) && $order->orderStatus == 1) ? "selected" : '' ?>>Számlázva</option>
                                    <option value="2" <?php echo (isset($order->orderStatus) && $order->orderStatus == 2) ? "selected" : '' ?>>Fizetve</option>
                                </select>
                            </div>
                        </div>
                        <hr>
                        <?php } ?>
                        <div class="row">
                            <div class="col-4">
                                Megrendelés törlése</br>
                                <small>XXX</small>
                            </div>
                            <div class="col-8">
                                <button type="button" class="btn btn-block btn-danger deleteOrder" data-id="<?php echo (isset($order->id)) ? $order->id : '' ?>">Törlés</button>
                            </div>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    Termékek
                </div>
                <div class="card-body productList">
                    Hozzáadott termékek listája
                </div>
                <div class="card-footer row">
                    <div class="col-lg-2  col-sm-12">
                        <button type="button" class="btn btn-block bg-gradient-primary btn-md addToOrder"><i class="fas fa-plus"></i>Hozzáadás</button>
                    </div>
                    <div class="col-lg-3 col-sm-11 form-group">
                        <select class="select2 selectProduct form-control" data-placeholder="Válassza ki a terméket"></select>
                    </div>
                    <div class="col-lg-2 col-sm-6 form-group">
                        <input class="quantitity form-control" type="number" placeholder="mennyiség">
                    </div>
                </div>
            </div>
        </div>
    </form>
    <div class="shadow" style="background-color: rgba(0,0,0,0.7);cursor:pointer;display:none;z-index:9999999;position:fixed;width:100%;height:100%;top:0;left:0;">
        <div class="card popup" style="position:fixed;top:10%;left:10%;width:80%;height:80%">
            <div class="card-header bg-gradient-success">
                <h3></h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-3"><strong>Termék leírás</strong></div>
                    <div class="productDesc col-9"></div>
                </div>
                <div class="row">
                    <div class="col-3"><strong>Termék egység ára:</strong></div>
                    <div class="productPrice col-9"></div>
                </div>
            </div>
            <div class="card-footer">
                <button class="btn btn-block bg-gradient-danger closeWindow">Ablak bezárása</button>
            </div>
        </div>
    </div>
    <script>
        //let orderLoad = JSON.parse(`<?php echo str_replace("\\", "\/", json_encode($order)); ?>`);
        let orderLoad = JSON.parse(`<?php echo addslashes(json_encode($order)); ?>`);
        let productList = JSON.parse(`<?php echo json_encode($order->body); ?>`);
        let user = <?php echo $user->id ?>;
        const isadmin = <?php echo ($user->accesslevel==0)?'true':'false'?>;
        let currentOrder = <?php echo $_GET['id'] ?>;
        let currentPriceRange = <?php echo (isset($order->customer->companyPriceRange)) ? $order->customer->companyPriceRange : 'null'; ?>;
    </script>
<?php
    addJS("orderupdate.js");
else :
    header("Location: " . SITEURL . "/orders/order/orderedit?id=" . $_GET['id']);
endif;
?>
