<?php
global $user;
if ($user->accesslevel > 1) {
    $filter = ['salesPerson' => $user->id];
    $result = $auth->getApiDataFilter("get/orders", $filter);
} else {
    $result = $auth->getApiData("get/orders");
}
if (!isset($result->errorcode)) {
    //print_r($result);
?>
    <div class="card">
        <input type="text" class="form-control filterSearch" placeholder="Gyors szűrés ...">
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Partnerek</h3>

            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <div class="card-body table-responsive p-0">
            <table class="table table-hover text-nowrap projects">
                <thead>
                    <tr>
                        <th style="width: 1%">
                            #
                        </th>
                        <th style="max-width: 300px;">Partner</th>
                        <th>Sz.T.</th>
                        <th>Összesen</th>
                        <th>Elfogadva</th>
                        <th style="width: 20%">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    //print_r($result);
                    foreach ($result as $o) :
                    ?>
                        <tr class="orderitem" data-filter-companyName="<?php echo $o->customer->companyName; ?>" data-filter-passId="<?php echo $o->id; ?>" data-filter-salesPersonName="<?php echo $o->salesPersonName; ?>">
                            <td>
                                <?php echo $o->id; ?>
                            </td>
                            <td style="max-width: 300px;">
                                <?php echo $o->customer->companyName; ?></br>
                                <small><?php echo $o->date; ?></small>
                            </td>
                            <td>
                                <?php
                                echo $o->salesPersonName
                                ?>
                            </td>
                            <td>
                                <?php
                                echo attendNum($o->total) . " Ft";
                                ?>
                            </td>
                            <td>
                                <?php echo (isset($o->orderAccept)&&$o->orderAccept==2)?"Igen":"<span class=\"pending-order\">Nem</span>"?>
                            </td>
                            <td class="project-actions text-right">
                                <a class="btn btn-primary btn-sm" href="<?php echo SITEURL ?>/orders/order/orderview?id=<?php echo $o->id ?>">
                                    <i class="fas fa-folder">
                                    </i>
                                    Nézet
                                </a>
                                <?php if ($user->accesslevel < 2 || false) : ?>
                                    <a class="btn btn-info btn-sm" href="<?php echo SITEURL ?>/orders/order/orderedit?id=<?php echo $o->id ?>">
                                        <i class="fas fa-pencil-alt">
                                        </i>
                                        Szerkesztés
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php
                    endforeach;
                    ?>
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
    </div>
<?php
    addJS("orderlist.js?1.0.3");
}
?>