<?php
class classWidgetService extends AuthClass
{
    private $auth;
    private $data;
    const CLASSNAME = "balance-widget";
    private $ERRORTRES = 2;
    private $viewUrl = "/automates/automateslist/view?econid=";
    private $size = "col-lg-6 col-sm-12";
    function __construct()
    {
        $this->auth = new AuthClass;
        $this->getData();
    }
    private function getData()
    {
        $today = explode("-", date("Y-n-j", strtotime("Now")));
        $filter = ['year' => $today[0], 'month' => $today[1], 'day' => $today[2]];
        $result = $this->auth->getApiDataFilter('get/service/informations', $filter);
        $this->render($result);
    }
    private function render($data)
    {
?>
        <div class="card <?php echo $this->size ?>">
            <div class="card-header">
                <h5>Szervíz</h5>
            </div>
            <div class="card-body">
                <?php
                foreach ($data as $d) {
                    $nextService = (isset($d->lastService))?convertToDate($d->lastService):'-';
                    if ($this->countErrors($d->services) > 2 || !isset($d->lastService)) {
                ?>
                        <div class="row form-group">
                            <div class="col-6">
                                <?php echo $d->econparams->title . " - " . $d->econparams->city; ?>
                            </div>
                            <div class="col-2">
                                <?php
                                if($nextService=="-"||strtotime($nextService."+".$d->econparams->serviceInterval."Day")<strtotime("Now")){
                                    echo "Support!";
                                }else{
                                    echo "Support rendben!";
                                }
                                ?></br>
                                <small><?php echo $nextService; ?></small>
                            </div>
                            <div class="col-2">
                                <?php
                                echo $this->generateErrors($d->services)
                                ?>
                            </div>
                            <div class="col-2">
                                <?php echo $this->generateButton($d->id) ?>
                            </div>
                        </div>
                <?php
                    }
                }
                ?>
            </div>
        </div>
<?php
    }
    private function countErrors($services)
    {
        $n = 0;
        for ($i = 0; $i < count($services); $i++) {
            if (!isset($services[$i]->status) || $services[$i]->status != "Running") {
                $n++;
            }
        }
        return $n;
    }
    private function generateErrors($services)
    {
        $n = 0;
        for ($i = 0; $i < count($services); $i++) {
            if (!isset($services[$i]->status) || $services[$i]->status != "Running") {
                $n++;
            }
        }
        if ($n > $this->ERRORTRES) {
            $n = '<span class="badge badge-danger">ERROR</span>';
        } else {
            $n = '<span class="badge badge-success">Minden ok</span>';
        }
        return $n;
    }
    private function generateButton($id)
    {
        $return = '<a class="btn btn-primary btn-sm" href="http://dashboard.econautomata.com/automates/automateslist/view?econid=' . $id . '">
                        <i class="fas fa-folder">
                        </i>
                        Nézet
                    </a>';
        return $return;
    }
}
?>