<?php
class classWidgetCommision extends AuthClass
{
    private $auth;
    private $data;
    const CLASSNAME = "balance-commision";
    private $ERRORTRES = 2;
    private $viewUrl = "/automates/automateslist/view?econid=";
    private $size = "col-lg-6 col-sm-12";
    private $currentuser;
    function __construct($id)
    {
        global $user;
        $this->currentuser = $user;
        $this->auth = new AuthClass;
        $this->getData($id);
    }
    private function getData($id)
    {
        $result = $this->auth->getApiDataFilter('get/commision', ['id' => $id]);
        $this->render($result);
    }
    private function render($data)
    {
?>
        <div class="card <?php echo $this->size ?>">
            <div class="card-header">
                <h5>Jutalék</h5>
            </div>
            <div class="card-body">
                <div class="row form-group">
                    <div class="col-6">
                        <?php echo "Jutalék alap:" ?>
                    </div>
                    <div class="col-6">
                        <?php
                        if (!isset($data->errorcode)) {
                            if(isset($this->currentuser->userTax)&&$this->currentuser->userTax=="0"){
                                echo $data[0]->commissionKata . " Ft";
                            }else{
                                echo $data[0]->commission . " Ft";
                            }
                        } else {
                            echo "0 Ft";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
    private function countErrors($services)
    {
        $n = 0;
        for ($i = 0; $i < count($services); $i++) {
            if (!isset($services[$i]->status) || $services[$i]->status != "Running") {
                $n++;
            }
        }
        return $n;
    }
    private function generateErrors($services)
    {
        $n = 0;
        for ($i = 0; $i < count($services); $i++) {
            if (!isset($services[$i]->status) || $services[$i]->status != "Running") {
                $n++;
            }
        }
        if ($n > $this->ERRORTRES) {
            $n = '<span class="badge badge-danger">ERROR</span>';
        } else {
            $n = '<span class="badge badge-success">Minden ok</span>';
        }
        return $n;
    }
    private function generateButton($id)
    {
        $return = '<a class="btn btn-primary btn-sm" href="http://dashboard.econautomata.com/automates/automateslist/view?econid=' . $id . '">
                        <i class="fas fa-folder">
                        </i>
                        Nézet
                    </a>';
        return $return;
    }
}
?>