<?php
class classWidgetBalance extends AuthClass
{
    private $auth;
    private $data;
    const CLASSNAME = "balance-widget";
    private $size = "col-lg-6 col-sm-12";
    function __construct()
    {
        $this->auth = new AuthClass;
        $this->getData();
    }
    private function getData()
    {
        $today = explode("-", date("Y-n-j", strtotime("Now")));
        $filter = ['year' => $today[0], 'month' => $today[1], 'day' => $today[2]];
        $result = $this->auth->getApiDataFilter('get/balance/day', $filter);
        $this->render($result);
    }
    private function render($data)
    {
        $summed = 0;
?>
        <div class="card <?php echo $this->size?>">
            <div class="card-header">
                <h5>Mai bevétel</h5>
            </div>
            <div class="card-body">
                <?php
                foreach ($data as $d) {
                ?>
                    <div class="row">
                        <div class="col-7">
                            <?php echo $d->title." - ".$d->city;?>
                        </div>
                        <div class="col-5">
                        <?php echo $d->balance;$summed+=$d->balance;?> Ft
                        </div>
                    </div>
                <?php
                }
                ?>
                <div class="row">
                        <div class="col-7">
                            Összesen:
                        </div>
                        <div class="col-5">
                        <?php echo $summed;?> Ft
                        </div>
                    </div>
            </div>
        </div>
<?php
    }
}
?>