<?php
class AuthClass{
    function __construct(){
    }
    public function apiConnect(){
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => APILOC,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "cache-control: no-cache",
            'Authorization: ' . APIKEY,
            'Content-Encoding: gzip',
            'Accept-encoding: gzip',
            'Accept: application/json', 
            'Content-Type: application/json',
            'debugmode:'. DEBUG
        ),
        ));

        $res = curl_exec($curl);
        //print_r($res);
        $err = curl_error($curl);
        curl_close($curl);
        $res = gzdecode($res);
        //print_r($res);
        return $res;
    }
    public function getApiDataFilter($url,$data){
        $curl = curl_init();
        $apiLoc = APILOC.'/'.$url;
        $passToken = (isset($_COOKIE['econtoken'])&&$_COOKIE['econtoken']!='')?$_COOKIE['econtoken']:'';
        //echo $apiLoc;
        curl_setopt_array($curl, array(
        CURLOPT_URL => $apiLoc,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_POSTFIELDS => gzencode(json_encode($data)),
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json', 
            'Content-Type: application/json',
            'Content-Encoding: gzip',
            'Accept-encoding: gzip',
            "cache-control: no-cache",
            'Authorization: ' . APIKEY,
            "RequestedUrl: " . $url,
            "PassToken: ". $passToken,
            'debugmode:'. DEBUG
        ),
        ));
        $res = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        //if($url=="update/order") print_r($res);
        if(DEBUG==false){
            $res = gzdecode($res);
        }
        //print_r($res);
        if($this->isJson($res)){
            $res = json_decode($res);
        }else{
            $res = $res;
        }
        
        return $res;
    }
    public function getApiData($url){
        $curl = curl_init();
        $apiLoc = APILOC.'/'.$url;
        $passToken = (isset($_COOKIE['econtoken'])&&$_COOKIE['econtoken']!='')?$_COOKIE['econtoken']:'';
        curl_setopt_array($curl, array(
        CURLOPT_URL => $apiLoc,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json', 
            'Content-Type: application/json',
            'Content-Encoding: gzip',
            'Accept-encoding: gzip',
            "cache-control: no-cache",
            "PassToken: ". $passToken,
            'Authorization: ' . APIKEY,
            "RequestedUrl: " . $url,
            'debugmode:'. DEBUG
        ),
        ));

        $res = curl_exec($curl);
        //print_r($res);
        $err = curl_error($curl);
        curl_close($curl);
        $res = gzdecode($res);
        //print_r($res);
        if($this->isJson($res)){
            $res = json_decode($res);
        }else{
            $res = $res;
        }
        
        return $res;
    }
    public function sendApiData($url,$data){
        //echo "ApiGet URL:".$url."</br>";
        $curl = curl_init();

        $apiLoc = APILOC.'/'.$url;
        //echo $apiLoc;
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $apiLoc,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => gzencode(json_encode($data)),
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json', 
            'Content-Type: application/json',
            "cache-control: no-cache",
            'Content-Encoding: gzip',
            'Accept-encoding: gzip',
            "Authorization: " . APIKEY,
            "RequestedUrl: " . $url,
            'debugmode:'. DEBUG
        ),
        ));

        $res = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        //print_r($res);
        $res = gzdecode($res);
        if($this->isJson($res)){
            $res = json_decode($res);
        }else{
            $res = $res;
        }
        return $res;
    }
    public function checkLogin($data){
        $curl = curl_init();
        $url = "login";
        $apiLoc = APILOC.'/'.$url;
        //echo $apiLoc;
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $apiLoc,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json', 
            'Content-Type: application/json',
            "cache-control: no-cache",
            "Authorization: " . APIKEY,
            "RequestedUrl: " . $url

        ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if($this->isJson($response)){
            $req = json_decode($response);
        }else{
            $req = $response;
        }
        $req = gzdecode($req);
        return $req;
    }
    public function isJson($string)
    {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }      
}
?>