<?php
global $JSEXTRA;
function loadCSS($extra = '')
{
    $default = '
    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/fontawesome-free/css/all.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="' . SITEURL . '/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <!-- JQVMap -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/jqvmap/jqvmap.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="' . SITEURL . '/dist/css/adminlte.min.css">
    <!-- Theme Custom style -->
    <link rel="stylesheet" href="' . SITEURL . '/dist/css/custom.css">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/daterangepicker/daterangepicker.css">
    <!-- summernote -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/summernote/summernote-bs4.min.css">
    <!-- jsGrid -->
    <link rel="stylesheet" href="' . SITEURL . '/plugins/jsgrid/jsgrid.min.css">
    <link rel="stylesheet" href="' . SITEURL . '/plugins/jsgrid/jsgrid-theme.min.css">';
    if ($extra != '') {
        $default .= $extra;
    }
    return $default;
}
function loadJS($extra = '')
{
    global $JSEXTRA;
    $default = '
    <!-- jQuery -->
<script src="' . SITEURL . '/plugins/jquery/jquery.min.js"></script>
<!-- jQuery UI 1.11.4 -->
<script src="' . SITEURL . '/plugins/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge(\'uibutton\', $.ui.button)
</script>
<!-- Bootstrap 4 -->
<script src="' . SITEURL . '/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="' . SITEURL . '/plugins/select2/js/select2.full.min.js"></script>
<!-- ChartJS -->
<script src="' . SITEURL . '/plugins/chart.js/Chart.min.js"></script>
<!-- Sparkline -->
<script src="' . SITEURL . '/plugins/sparklines/sparkline.js"></script>
<!-- JQVMap -->
<script src="' . SITEURL . '/plugins/jqvmap/jquery.vmap.min.js"></script>
<script src="' . SITEURL . '/plugins/jqvmap/maps/jquery.vmap.usa.js"></script>
<!-- jQuery Knob Chart -->
<script src="' . SITEURL . '/plugins/jquery-knob/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="' . SITEURL . '/plugins/moment/moment.min.js"></script>
<script src="' . SITEURL . '/plugins/daterangepicker/daterangepicker.js"></script>

<!-- Tempusdominus Bootstrap 4 -->
<script src="' . SITEURL . '/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Summernote -->
<script src="' . SITEURL . '/plugins/summernote/summernote-bs4.min.js"></script>
<!-- overlayScrollbars -->
<script src="' . SITEURL . '/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
<!-- AdminLTE App -->
<script src="' . SITEURL . '/dist/js/adminlte.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="' . SITEURL . '/dist/js/demo.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="' . SITEURL . '/dist/js/pages/dashboard.js"></script>
<script src="' . SITEURL . '/plugins/jsgrid/jsgrid.min.js"></script>';
    $default .= $JSEXTRA;
    return $default;
}
function convertToDate($mongodate)
{
    foreach ($mongodate as $date) {
        foreach ($date as $d) {
            $datestring = date("Y-m-d H:i:s", $d / 1000);
        }
    }
    //print_r($datestring);
    return $datestring;
}
function addJS($jsfile)
{
    global $JSEXTRA;
    $add = '<script src="' . JSPATH . $jsfile . '"></script>';
    $JSEXTRA .= $add;
}
function hasAccess()
{
    global $menus;
    global $user;
    $requesturl = $_SERVER['REQUEST_URI'];
    if ($requesturl != "/") {
        if (strpos($requesturl, "?") > 0) {
            $requesturl = substr($requesturl, 0, strpos($requesturl, "?"));
        }
        $requesturl = explode("/", $requesturl);
        //Depth of the rabbit hole
        $final = $menus;
        for ($i = 1; $i < (count($requesturl)); $i++) {
            if (isset($final['submenu'])) {
                $final = $final['submenu'][$requesturl[$i]];
            } else {
                $final = $final[$requesturl[$i]];
            }
        }
        //print_r($final);
        if ($user->accesslevel <= $final['accesslevel']) {
            return 1;
        } else {
            return 0;
        }
    } else {
        return 1;
    }
}
function sendCallout($type, $header, $text)
{
    $str = "<div class=\"callout callout-{$type}\">
    <h6>{$header}</h6>

    <p>{$text}</p>
  </div>";
    return $str;
}
function sendAlert($type, $header, $text)
{
    $str = '<div class="alert alert-' . $type . ' alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
    <h5><i class="icon fas fa-check"></i> Alert!</h5>
    Success alert preview. This alert is dismissable.
    </div>';
    return $str;
}
function convertIDtoString($id)
{
    foreach ($id as $i) {
        $id = $i;
    }
    return $id;
}
function getAccessLevels($which = '')
{
    $result = ['Adminisztrátor', 'Ügyintéző', 'Értékesítő', 'Deaktivált'];
    if ($which == '') {
        return $result;
        //return $result;
    } else {
        return $result[(int)$which];
    }
}
function getTax($which = '')
{
    $result = ['KATA', 'Cég áfa', 'E.V. áfa', 'Cég AAM'];
    if ($which == '') {
        return $result;
    } else {
        return $result[(int)$which];
    }
}
function getUnitsById($which=0){
    $result = ['kg', 'l','db'];
    return $result[$which];
}
function getUnits($which = "")
{
    $result = ['kg', 'l','db'];
    if ($which == '') {
        return $result;
    } else {
        return $result[(int)$which];
    }
}
function getJutalek($which = "")
{
    $result = ['%', 'Ft'];
    if ($which == '') {
        return $result;
    } else {
        return $result[(int)$which];
    }
}
function selectStatus($index){
    $status = ['Megrendelve','Kiszállítás alatt','Kiszállítva','Számlázva','Fizetve','Jutalék'];
    return $status[$index];
}
function generateStatusSelect($id){
    //$id = intval($i);
    $selected = ($id==0)?'selected':'';
    $html = "<option value=\"0\" {$selected}>Megrendelve</option>";
    $selected = ($id==1)?'selected':'';
    $html .= "<option value=\"1\" {$selected}>Kiszállítás alatt</option>";
    $selected = ($id==2)?'selected':'';
    $html .= "<option value=\"2\" {$selected}>Kiszállítva</option>";
    $selected = ($id==3)?'selected':'';
    $html .= "<option value=\"3\" {$selected}>Számlázva</option>";
    $selected = ($id==4)?'selected':'';
    $html .= "<option value=\"4\" {$selected}>Fizetve</option>";
    $selected = ($id==5)?'selected':'';
    $html .= "<option value=\"5\" {$selected}>Jutalék</option>";
    return  $html;
  }
function attendNum($num){
    if(is_numeric($num)){
        if(is_decimal($num))
            return number_format($num,2,",",' ');
            return number_format($num,0,"",' ');
    }else{
        return $num;
    }
}
function is_decimal( $val )
{
    return is_numeric( $val ) && floor( $val ) != $val;
}