$("button.savedata").on("click", function (e) {
  let target = $(e.currentTarget).parent().parent().parent();
  let data = $(target).data();
  let send = {
    delivery: $(target).find("input.delivery").val(),
    ekaer: $(target).find("input.ekaer").val(),
    status: $(target).find("select.status").val(),
    invoiceNum: $(target).find("input.invoiceNum").val(),
    invoiceDate: $(target).find("input.invoiceDate").val(),
    ordernum: $(target).find("input.ordernum").val(),
    isfix:($(target).find("input.isfix").is(':checked'))?"true":"false",
  };
  send = { ...send, ...data };
  console.log(send);
  $.ajax({
    url: "/ajax/update/order/body",
    dataType: "json",
    type: "GET",
    async: false,
    data: send,
    success: function (res) {
      //console.log($(e.currentTarget).data())
      if ($(e.currentTarget).data("status") != send.status) {
        $(target).remove();
      }
    },
  });
});
$("input.filterSearch").on("keyup", function () {
  let re = new RegExp($("input.filterSearch").val(), "i");
  $(document)
    .find("div.orderitem")
    .css("display", "none")
    .filter(function () {
      if (re.test($(this).attr("data-filter-productName")))
        $(this).css("display", "block");
      if (re.test($(this).attr("data-filter-companyName")))
        $(this).css("display", "block");
    });
});
$("input.delivery").daterangepicker({
  minDate: new Date(),
  singleDatePicker: false,
  autoUpdateInput: false,
  locale: {
    format: "YYYY-MM-DD",
    separator: " - ",
    applyLabel: "Mentés",
    cancelLabel: "Mégse",
    daysOfWeek: ["V", "H", "K", "Sze", "Cs", "P", "Szo"],
    monthNames: [
      "Január",
      "Február",
      "Március",
      "Április",
      "Május",
      "Június",
      "Július",
      "Augusztus",
      "Szeptember",
      "Október",
      "November",
      "December",
    ],
    firstDay: 1,
  },
});
$("input.invoiceDate").daterangepicker({
  //minDate: new Date(),
  singleDatePicker: false,
  autoUpdateInput: false,
  locale: {
    format: "YYYY-MM-DD",
    separator: " - ",
    applyLabel: "Mentés",
    cancelLabel: "Mégse",
    daysOfWeek: ["V", "H", "K", "Sze", "Cs", "P", "Szo"],
    monthNames: [
      "Január",
      "Február",
      "Március",
      "Április",
      "Május",
      "Június",
      "Július",
      "Augusztus",
      "Szeptember",
      "Október",
      "November",
      "December",
    ],
    firstDay: 1,
  },
});
$('input.invoiceDate,input.delivery').on('apply.daterangepicker', function(ev, picker) {
  if (!picker.startDate.isValid() || !picker.endDate.isValid()) {
    $(this).val('')
    return;
  }
  let startDate = formatDate(picker.startDate._d)
  let endDate   = formatDate(picker.endDate._d)
  $(this).val(`${startDate} - ${endDate}`);
});
function formatDate(date) {
  var d = new Date(date),
      month = '' + (d.getMonth() + 1),
      day = '' + d.getDate(),
      year = d.getFullYear();

  if (month.length < 2) 
      month = '0' + month;
  if (day.length < 2) 
      day = '0' + day;

  return [year, month, day].join('-');
}
