$(function () {
  var start = moment();
  var end = moment().add(30, "days");
  function cb(start, end) {
    /*$("#dateRange span").html(
        start.format("Y-m-d") + " - " + end.format("Y-m-d")
      );*/
  }

  $("#dateRange").daterangepicker(
    {
      locale: {
        format: "Y-MM-DD",
        separator: " - ",
        applyLabel: "Ok",
        cancelLabel: "Mégse",
        fromLabel: "-től",
        toLabel: "-ig",
        customRangeLabel: "Egyedi",
        weekLabel: "Hét",
        daysOfWeek: ["Vas", "H", "K", "Sze", "Cs", "P", "Szo"],
        monthNames: [
          "Január",
          "Február",
          "Március",
          "Április",
          "Május",
          "Június",
          "Július",
          "Augusztus",
          "Szeptember",
          "Október",
          "November",
          "December",
        ],
        firstDay: 1,
      },
      ranges: {
        Ma: [moment(), moment()],
        Holnap: [moment().subtract(1, "days"), moment().subtract(1, "days")],
        "Következő 7 nap": [moment().add(6, "days"), moment()],
        "Következő 30 nap": [moment().add(29, "days"), moment()],
        "Ez a hónap": [moment().startOf("month"), moment().endOf("month")],
        "Következő hónap": [
          moment().add(1, "month").startOf("month"),
          moment().add(1, "month").endOf("month"),
        ],
        "Ez az év": [moment().startOf("year"), moment().endOf("year")],
        "Múlt év": [moment().subtract(365, "days"), moment()],
      },
    },
    cb
  );

  cb(start, end);
});
$("select.cols").select2();
$("select.filterpartner").select2({
  ajax: {
    url: "/ajax/get/statistic/partner",
    dataType: "json",
    type: "GET",
    data: function (params) {
      var query = {
        name: params.term,
      };
      // Query parameters will be ?search=[term]&type=public
      return query;
    },
    processResults: function (data) {
      // Transforms the top-level key of the response object from 'items' to 'results'
      var data = $.map(data, function (obj) {
        obj.id = obj.id;
        obj.text = obj.companyName; // replace pk with your identifier
        //obj.text = obj.text + " - " + obj.id;
        return obj;
      });
      return {
        results: data,
      };
    },
  },
});
$("select.filterproduct").select2({
    ajax: {
      url: "/ajax/get/statistic/product",
      dataType: "json",
      type: "GET",
      data: function (params) {
        var query = {
          name: params.term,
        };
        // Query parameters will be ?search=[term]&type=public
        return query;
      },
      processResults: function (data) {
        // Transforms the top-level key of the response object from 'items' to 'results'
        var data = $.map(data, function (obj) {
          obj.id = obj.id;
          obj.text = obj.productName; // replace pk with your identifier
          //obj.text = obj.text + " - " + obj.id;
          return obj;
        });
        return {
          results: data,
        };
      },
    },
  });
  $("select.filtersalesperson").select2({
    ajax: {
      url: "/ajax/get/statistic/salesperson",
      dataType: "json",
      type: "GET",
      data: function (params) {
        var query = {
          name: params.term,
        };
        // Query parameters will be ?search=[term]&type=public
        return query;
      },
      processResults: function (data) {
        // Transforms the top-level key of the response object from 'items' to 'results'
        var data = $.map(data, function (obj) {
          obj.id = obj.id;
          obj.text = obj.lastName + " " + obj.firstName; // replace pk with your identifier
          //obj.text = obj.text + " - " + obj.id;
          return obj;
        });
        return {
          results: data,
        };
      },
    },
  });
$("button.filterme").on("click", function () {
  let _filterpartner = $("select.filterpartner").val();
  let _filtersalesperson = $("select.filtersalesperson").val();
  let _filterproduct = $("select.filterproduct").val();
  let _daterange = $("input#dateRange").val();
  let _cols = $("select.cols").val();
  let _data = {
    filterproduct:_filterproduct,
    filtersalesperson: _filtersalesperson,
    filterpartner: _filterpartner,
    filterdaterange: _daterange,
    cols: _cols,
  };
  console.log(_data);
  $.ajax({
    url: "/ajax/get/statistic",
    dataType: "json",
    type: "GET",
    delay: 250,
    data: _data,
  }).done(function (jsonData) {
      let _fields = [];
      for(c of _cols){
        let _type = (c=='quantity')?'number':'text';
        _type = (c=="total")?"number":_type;
        if(c=="total"){
            _fields.push({ name: c, type: _type, width: 100, title: c ,itemTemplate:function(v,i){
                console.log(v);
                return v.toLocaleString()+" Ft";
            }})
        }else{
            _fields.push({ name: c, type: _type, width: 100, title: c })
        }
      }
    $("#table").jsGrid({
      width: "100%",
      height: "600px",
      readonly: true,
      sorting: true,
      paging: true,
      pageSize: 50,
      data: jsonData,
      fields: _fields,
    });
  });
});