Date.prototype.getWeek = function () {
  var date = new Date(this.getTime());
  date.setHours(0, 0, 0, 0);
  // Thursday in current week decides the year.
  date.setDate(date.getDate() + 3 - ((date.getDay() + 6) % 7));
  // January 4 is always in week 1.
  var week1 = new Date(date.getFullYear(), 0, 4);
  // Adjust to Thursday in week 1 and count number of weeks from date to week1.
  return (
    1 +
    Math.round(
      ((date.getTime() - week1.getTime()) / 86400000 -
        3 +
        ((week1.getDay() + 6) % 7)) /
        7
    )
  );
};
var days = function (month, year) {
  return new Date(year, month, 0).getDate();
};
$(".datepicker").daterangepicker({
  singleDatePicker: true,
  firstDay: 1,
  locale: {
    format: "YYYY-MM-DD",
    separator: " - ",
    firstDay:1,
    applyLabel: "Mentés",
    cancelLabel: "Mégse",
    startView: "months", 
    minViewMode: "months",
    daysOfWeek: ["V", "H", "K", "Sze", "Cs", "P", "Szo"],
    monthNames: [
      "Január",
      "Február",
      "Március",
      "Április",
      "Május",
      "Június",
      "Július",
      "Augusztus",
      "Szeptember",
      "Október",
      "November",
      "December",
    ],
  },
});
$("button.refreshData").on("click", function (ev, picker) {
  let dateText = $(".datepicker").val();
  $(this).datepicker("setDate", new Date(dateText));
  let date = new Date(dateText);
  let dateType = $("#dateType").val();
  switch (dateType) {
    case "year":
      loadTable('',{ year: date.getFullYear() });
      break;
    case "month":
      loadTable('',{year: date.getFullYear(),month: date.getMonth() + 1,});
      break;
    case "week":
      loadTable('',{ year: date.getFullYear(), week: date.getWeek() });
      break;
    case "day":
      loadTable('',{year: date.getFullYear(),month: date.getMonth() + 1,day: date.getDate(),});
      break;
  }
});
function loadTable(path, parameters) {
  var form = $('<form></form>');

  form.attr("method", "post");
  form.attr("action", path);

  $.each(parameters, function(key, value) {
      var field = $('<input></input>');

      field.attr("type", "hidden");
      field.attr("name", key);
      field.attr("value", value);

      form.append(field);
  });

  // The form needs to be a part of the document in
  // order for us to be able to submit it.
  $(document.body).append(form);
  form.submit();
}