$("select.companySale").select2();
$("select.productCategory").select2();
$("select.productUnit").select2();
$("select.productJutalekKATA").select2();
$("select.productNormal").select2();
$(
  "select.companyCity,select.companyPostalCity,select.companyLocationCity"
).select2({
  ajax: {
    url: "/ajax/get/cities",
    dataType: "json",
    type: "GET",
    data: function (params) {
      var query = {
        city: params.term,
      };

      // Query parameters will be ?search=[term]&type=public
      return query;
    },
    processResults: function (data) {
      // Transforms the top-level key of the response object from 'items' to 'results'
      var data = $.map(data, function (obj) {
        obj.id = obj.id || obj._id.$oid;
        obj.text = obj.text || obj.city + " " + obj.zip; // replace pk with your identifier
        //obj.text = obj.text + " - " + obj.id;
        return obj;
      });
      return {
        results: data,
      };
    },
  },
});
$(
  "select.companyCounty,select.companyPostalCounty,select.companyLocationCounty"
).select2({
  ajax: {
    url: "/ajax/get/counties",
    dataType: "json",
    type: "GET",
    data: function (params) {
      var query = {
        name: params.term,
      };

      // Query parameters will be ?search=[term]&type=public
      return query;
    },
    processResults: function (data) {
      // Transforms the top-level key of the response object from 'items' to 'results'
      var data = $.map(data, function (obj) {
        obj.id = obj.id || obj.name;
        obj.text = obj.text || obj.name; // replace pk with your identifier
        //obj.text = obj.text + " - " + obj.id;
        return obj;
      });
      return {
        results: data,
      };
    },
  },
});

$("select.companyCountry").select2();
$("select.companyLocationCountry").select2();
$("select.companyPostalCountry").select2();

$("button.savedata").on("click", function (e) {
  var allAttributes = jQuery("input.form-control,select.form-control")
    .map(function () {
      /* example: .class */ let record = {
        key: $(this).attr("name"),
        value: $(this).val(),
      };
      return record; /* example: id */
    })
    .get();
  $("#sendForm").submit();
});
let table = $("#partner").jsGrid({
  height: "auto",
  width: "100%",
  sorting: true,
  paging: true,
  autoload: true,
  filtering: true,
  controller: {
    loadData: function (filter2) {
      //console.log(filter);
      return $.ajax({
        type: "GET",
        url: "/ajax/get/partner/short",
        data: { filter: filter2.companyName },
        dataType: "json",
      }).then(function (result) {
        //console.log(result);
        return result;
      });
    },
  },

  fields: [
    {
      //name: "companyVat",
      title: "Cím",
      type: "text",
      sorting:true,
      filtering: false,
      itemTemplate: function (value,data) {
        return `${data.companyCity}`;
      },
    },
    { name: "companyName", title: "Partner", type: "text", filtering: true },
    {
      name: "id",
      title: "Művelet",
      type: "number",
      width: 50,
      filtering: false,
      css: "text-center",
      itemTemplate: function (value) {
        return `<a class="btn btn-info btn-sm" href="/partners/partner/edit?id=${value}">
              <i class="fas fa-pencil-alt">
              </i>
          </a> <a class="btn btn-primary btn-sm" href="/partners/partner/view?id=${value}">
          <i class="fas fa-folder">
          </i>
      </a>`;
      },
    },
  ],
});
