$(document).ready(function () {
  $("button.commissionFilter").on("click", function () {
    let db;
    let query = {};
    if ($("select.salesPerson").val() != "0") {
      query = {
        id: $("select.salesPerson").val(),
        daterange: $("input.commissionRange").val(),
      };
    } else {
      query = {
        daterange: $("input.commissionRange").val(),
      };
    }
    console.log(query);
    $.ajax({
      url: "/ajax/get/commision/daterange",
      dataType: "json",
      type: "GET",
      async: true,
      data: query,
      success: function (res) {
        if (res.errocode == 0) {
          db = [];
        } else {
          db = res[0];
        }
      },
    }).then(function (t) {
      let commi = "commission";
      if (t.errocode == 0) {
        db = [];
      } else {
        if (db.salesPerson.userTax == "0" || db.salesPerson.userTax == "3")
          commi = "commissionKata";
      }
      $(function () {
        $("#jsGrid").jsGrid({
          width: "100%",
          autosearch: true,
          sorting: true,
          paging: true,
          data: db.order,
          fields: [
            {
              name: "orderhead",
              title: "#",
              type: "number",
              width: 50,
              align: "center",
              itemTemplate: function (value) {
                return `#PASS-${value}`;
              },
            },
            {
              name: "productName",
              title: "Termék neve",
              type: "text",
              width: 150,
              filtering: true,
            },
            { name: "companyName", title: "Partner", type: "text", width: 150 },
            { name: `${commi}`, title: "Jutalék", type: "number", width: 150 },
          ],
          rowClick: function (args) {
            //console.log(args.item);
            //console.log(args.item.id);
            window.location =
              "/orders/order/orderview?id=" + args.item.orderhead;
          },
        });
      });
    });
  });
  $("input.commissionRange").daterangepicker({
    singleDatePicker: false,
    locale: {
      format: "YYYY-MM-DD",
      separator: " - ",
      applyLabel: "Ok",
      cancelLabel: "Mégse",
      fromLabel: "-től",
      toLabel: "-ig",
      customRangeLabel: "Egyedi",
      weekLabel: "Hét",
      daysOfWeek: ["Vas", "H", "K", "Sze", "Cs", "P", "Szo"],
      monthNames: [
        "Január",
        "Február",
        "Március",
        "Április",
        "Május",
        "Június",
        "Július",
        "Augusztus",
        "Szeptember",
        "Október",
        "November",
        "December",
      ],
      firstDay: 1,
    },
    ranges: {
      Ma: [moment(), moment()],
      Holnap: [moment().subtract(1, "days"), moment().subtract(1, "days")],
      "Következő 7 nap": [moment().add(6, "days"), moment()],
      "Következő 30 nap": [moment().add(29, "days"), moment()],
      "Ez a hónap": [moment().startOf("month"), moment().endOf("month")],
      "Következő hónap": [
        moment().add(1, "month").startOf("month"),
        moment().add(1, "month").endOf("month"),
      ],
      "Ez az év": [moment().startOf("year"), moment().endOf("year")],
      "Múlt év": [moment().subtract(365, "days"), moment()],
    },
  });
});
