<?php
if ($requestUri == "get/statistic") {
    //echo json_encode($inputData);
    $inputData = changeStringToInt($inputData);
    $cmd = [];
    $match = [];
    if(isset($inputData['filtersalesperson'])&&$inputData['filtersalesperson']!=[]){
        $temp = ['$in'=>['$salesPerson',$inputData['filtersalesperson']]];
        $match[] = $temp;
    }
    if(isset($inputData['filterpartner'])&&$inputData['filterpartner']!=[]){
        $temp = ['$in'=>['$customer.id',$inputData['filterpartner']]];
        $match[] = $temp;
    }
    $cmd[]=['$match'=>['$expr'=>['$and'=>$match]]];
    $cmd[]=[
        '$lookup'=> [
            'from'=> 'orderbody', 
            'let'=> [
                'oh'=> '$id'
            ], 
            'pipeline'=> [
                [
                    '$match'=> [
                        '$expr'=> [
                            '$and'=> [
                                [
                                    '$eq'=> [
                                        '$orderhead', '$$oh'
                                    ]
                                ], [
                                    '$ne'=> [
                                        '', '$delivery'
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ], 
            'as'=> 'body'
        ]
    ];
    $cmd[]= [
        '$unwind'=> [
            'path'=> '$body'
        ]
    ];
    $cmd[]=[
        '$addFields'=> [
            'start'=> [
                '$arrayElemAt'=> [
                    [
                        '$split'=> [
                            '$body.delivery', ' - '
                        ]
                    ], 0
                ]
            ], 
            'end'=> [
                '$arrayElemAt'=> [
                    [
                        '$split'=> [
                            '$body.delivery', ' - '
                        ]
                    ], 1
                ]
            ]
        ]
    ];
    $cmd[]=[
        '$addFields'=> [
            'start'=> [
                '$arrayElemAt'=> [
                    [
                        '$split'=> [
                            '$body.delivery', ' - '
                        ]
                    ], 0
                ]
            ], 
            'end'=> [
                '$arrayElemAt'=> [
                    [
                        '$split'=> [
                            '$body.delivery', ' - '
                        ]
                    ], 1
                ]
            ]
        ]
    ];
    if(isset($inputData['filterdaterange'])){
        $range = explode(' - ',$inputData['filterdaterange']);
        $cmd[]=[
            '$match'=> [
                '$expr'=> [
                    '$and'=> [
                        [
                            '$gte'=> [
                                [
                                    '$toDate'=> '$start'
                                ], [
                                    '$toDate'=> $range[0]
                                ]
                            ]
                        ], [
                            '$lte'=> [
                                [
                                    '$toDate'=> '$end'
                                ], [
                                    '$toDate'=> $range[1]
                                ]
                            ]
                                ],
                                [
                                    '$gt'=>['$body.status',2]
                                ]
                    ]
                ]
            ]
        ];
    }
    if(isset($inputData['filterproduct'])&&$inputData['filterproduct']!=[]){
        $cmd[] = ['$match'=>['$expr'=>['$in'=>['$body.id',$inputData['filterproduct']]]]];
    }
    $cmd[]=[
        '$lookup'=> [
            'from'=> 'users', 
            'let'=> [
                'sp'=> '$salesPerson'
            ], 
            'pipeline'=> [
                [
                    '$match'=> [
                        '$expr'=> [
                            '$eq'=> [
                                '$id', '$$sp'
                            ]
                        ]
                    ]
                ]
            ], 
            'as'=> 'person'
        ]
    ];
    $cmd[]=[
        '$unwind'=> [
            'path'=> '$person'
        ]
    ];
    $cmd[]=[
        '$addFields'=> [
            'personName'=> [
                '$concat'=> [
                    '$person.lastName', ' ', '$person.firstName'
                ]
            ]
        ]
    ];
    $cols = [];
    if(isset($inputData['cols'])&&$inputData['cols']!=[]){
        foreach($inputData['cols'] as $c){
            switch($c){
                case 'salesperson':
                    $cols[$c]='$salesPerson';
                    break;
                    case 'partner':
                        $cols[$c]='$customer.companyName';
                    break;
                    case 'product':
                        $cols[$c]='$body.productName';
                    break;
                    case 'order':
                        $cols[$c]='$id';
                    break;
            }
        }
        $cmd[]=[
            '$group'=> [
                '_id'=> $cols, 
                'salesperson'=> [
                    '$first'=> '$personName'
                ], 
                'product'=> [
                    '$first'=> '$body.productName'
                ], 
                'quantity'=> [
                    '$sum'=> '$body.productQuantity'
                ], 
                'orderhead'=> [
                    '$first'=> '$id'
                ], 
                'partner'=> [
                    '$first'=> '$customer.companyName'
                ], 
                'total'=> [
                    '$sum'=> '$body.total'
                ],
                'date'=>[
                    '$first'=>'$body.delivery'
                ]
            ]
        ];
    }else{
        $cmd[]=[
            '$group'=> [
                '_id'=> ['salesperson'=>'$salesPerson'], 
                'salesperson'=> [
                    '$first'=> '$personName'
                ], 
                'product'=> [
                    '$first'=> '$body.productName'
                ], 
                'quantity'=> [
                    '$sum'=> '$body.productQuantity'
                ], 
                'orderhead'=> [
                    '$first'=> '$id'
                ], 
                'partner'=> [
                    '$first'=> '$customer.companyName'
                ], 
                'total'=> [
                    '$sum'=> '$body.total'
                ],
                'date'=>[
                    '$first'=>'$body.delivery'
                ]
            ]
        ];
    }
    /*echo "<pre>";
    print_r($cmd);
    echo "</pre>";
    echo json_encode($cmd);*/
    $result = $db->queryMDBV3("attend.orderhead", [], [], $cmd);
    $result = json_encode($result->toArray());
} else if ($requestUri == "get/statistic/salesperson") {
    //print_r("teszt");
    $data = $inputData;
    $data = changeStringToInt($data);
    //print_r($data);
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex('^' . $data['name'], 'i');
        $filter = ['lastName' => $regex];
    } else {
        $filter = [];
    }
    //print_r($filter);
    $options = [];
    $cmd = ['$project' => ['_id' => 0,'firstName'=>'$firstName','lastName'=>'$lastName','id'=>'$id'], '$limit' => 20];
    $response = $db->queryMDB("attend.users", $filter, $options, $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "get/statistic/partner") {
    //print_r("teszt");
    $data = $inputData;
    $data = changeStringToInt($data);
    //print_r($data);
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex('^' . $data['name'], 'i');
        $filter = ['companyName' => $regex];
    } else {
        $filter = [];
    }
    //print_r($filter);
    $options = [];
    $cmd = ['$project' => ['_id' => 0], '$limit' => 20];
    $response = $db->queryMDB("attend.partners", $filter, $options, $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "get/statistic/product") {
    //print_r("teszt");
    $data = $inputData;
    $data = changeStringToInt($data);
    //print_r($data);
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex('^' . $data['name'], 'i');
        $filter = ['productName' => $regex];
    } else {
        $filter = [];
    }
    //print_r($filter);
    $options = [];
    $cmd = ['$project' => ['_id' => 0], '$limit' => 20];
    $response = $db->queryMDB("attend.products", $filter, $options, $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
}
