<?php
if ($requestUri == "get/statistic") {
    //echo json_encode($inputData);
    $inputData = changeStringToInt($inputData);
    $cmd = [];
    $match = [];
    if (isset($inputData['filtersalesperson']) && $inputData['filtersalesperson'] != []) {
        $temp = ['$in' => ['$salesPerson', $inputData['filtersalesperson']]];
        $match[] = $temp;
    }
    if (isset($inputData['filterpartner']) && $inputData['filterpartner'] != []) {
        $temp = ['$in' => ['$customer.id', $inputData['filterpartner']]];
        $match[] = $temp;
    }
    $cmd[] = ['$match' => ['$expr' => ['$and' => $match]]];
    $cmd[] = [
        '$lookup' => [
            'from' => 'orderbody',
            'let' => [
                'oh' => '$id'
            ],
            'pipeline' => [
                [
                    '$match' => [
                        '$expr' => [
                            '$and' => [
                                [
                                    '$eq' => [
                                        '$orderhead', '$$oh'
                                    ]
                                ], [
                                    '$ne' => [
                                        '', '$delivery'
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ],
            'as' => 'body'
        ]
    ];
    $cmd[] = [
        '$unwind' => [
            'path' => '$body'
        ]
    ];
    $cmd[] = [
        '$addFields' => [
            'start' => [
                '$arrayElemAt' => [
                    [
                        '$split' => [
                            '$body.delivery', ' - '
                        ]
                    ], 0
                ]
            ],
            'end' => [
                '$arrayElemAt' => [
                    [
                        '$split' => [
                            '$body.delivery', ' - '
                        ]
                    ], 1
                ]
            ]
        ]
    ];
    $cmd[] = [
        '$addFields' => [
            'start' => [
                '$arrayElemAt' => [
                    [
                        '$split' => [
                            '$body.delivery', ' - '
                        ]
                    ], 0
                ]
            ],
            'end' => [
                '$arrayElemAt' => [
                    [
                        '$split' => [
                            '$body.delivery', ' - '
                        ]
                    ], 1
                ]
            ]
        ]
    ];
    $cmd[] = [
        '$addFields' => [
            'splitDate' => [
                '$dateToParts' => [
                    'date' => [
                        '$toDate' => '$orderDate'
                    ]
                ]
            ]
        ]
    ];
    if (isset($inputData['filterdaterange'])) {
        $range = explode(' - ', $inputData['filterdaterange']);
        $cmd[] = [
            '$match' => [
                '$expr' => [
                    '$and' => [
                        [
                            '$gte' => [
                                [
                                    '$toDate' => '$start'
                                ], [
                                    '$toDate' => $range[0]
                                ]
                            ]
                        ], [
                            '$lte' => [
                                [
                                    '$toDate' => '$end'
                                ], [
                                    '$toDate' => $range[1]
                                ]
                            ]
                        ],
                        [
                            '$gt' => ['$body.status', 2]
                        ]
                    ]
                ]
            ]
        ];
    }
    if (isset($inputData['filterproduct']) && $inputData['filterproduct'] != [] && is_array($inputData['filterproduct'])) {
        $cmd[] = ['$match' => ['$expr' => ['$in' => ['$body.id', $inputData['filterproduct']]]]];
    } else {
        $regex = new MongoDB\BSON\Regex('^' . $inputData['filterproduct'], 'i');
        $cmd[] = [
            '$match' => [
                'body.productName' => $regex
            ]
        ];
    }
    $cmd[] = [
        '$lookup' => [
            'from' => 'users',
            'let' => [
                'sp' => '$salesPerson'
            ],
            'pipeline' => [
                [
                    '$match' => [
                        '$expr' => [
                            '$eq' => [
                                '$id', '$$sp'
                            ]
                        ]
                    ]
                ]
            ],
            'as' => 'person'
        ]
    ];
    $cmd[] = [
        '$unwind' => [
            'path' => '$person'
        ]
    ];
    $cmd[] = [
        '$addFields' => [
            'personName' => [
                '$concat' => [
                    '$person.lastName', ' ', '$person.firstName'
                ]
            ]
        ]
    ];
    $cols = [];
    if (isset($inputData['cols']) && $inputData['cols'] != []) {
        foreach ($inputData['cols'] as $c) {
            switch ($c) {
                case 'salesperson':
                    $cols[$c] = '$salesPerson';
                    break;
                case 'partner':
                    $cols[$c] = '$customer.companyName';
                    break;
                case 'product':
                    $cols[$c] = '$body.productName';
                    break;
                case 'order':
                    $cols[$c] = '$id';
                    break;
                case 'year':
                    $cols[$c] = '$splitDate.year';
                    break;
                case 'month':
                    $cols[$c] = '$splitDate.month';
                    break;
                case 'day':
                    $cols[$c] = '$splitDate.day';
                    break;
            }
        }
        $cmd[] = [
            '$group' => [
                '_id' => $cols,
                'salesperson' => [
                    '$first' => '$personName'
                ],
                'product' => [
                    '$first' => '$body.productName'
                ],
                'quantity' => [
                    '$sum' => '$body.productQuantity'
                ],
                'orderhead' => [
                    '$first' => '$id'
                ],
                'partner' => [
                    '$first' => '$customer.companyName'
                ],
                'total' => [
                    '$sum' => '$body.total'
                ],
                'date' => [
                    '$first' => '$body.delivery'
                ],
                'year' => [
                    '$first' => '$splitDate.year'
                ],
                'month' => [
                    '$first' => '$splitDate.month'
                ],
                'day' => [
                    '$first' => '$splitDate.day'
                ]
            ]
        ];
    } else {
        $cmd[] = [
            '$group' => [
                '_id' => ['salesperson' => '$salesPerson'],
                'salesperson' => [
                    '$first' => '$personName'
                ],
                'product' => [
                    '$first' => '$body.productName'
                ],
                'quantity' => [
                    '$sum' => '$body.productQuantity'
                ],
                'orderhead' => [
                    '$first' => '$id'
                ],
                'partner' => [
                    '$first' => '$customer.companyName'
                ],
                'total' => [
                    '$sum' => '$body.total'
                ],
                'date' => [
                    '$first' => '$body.delivery'
                ]
            ]
        ];
    }
    /*echo "<pre>";
    print_r($cmd);
    echo "</pre>";
    echo json_encode($cmd);*/
    $result = $db->queryMDBV3("attend.orderhead", [], [], $cmd);
    $result = json_encode($result->toArray());
} else if ($requestUri == "get/statistic/salesperson") {
    //print_r("teszt");
    $data = $inputData;
    $data = changeStringToInt($data);
    //print_r($data);
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex('^' . $data['name'], 'i');
        $filter = ['lastName' => $regex];
    } else {
        $filter = [];
    }
    //print_r($filter);
    $options = [];
    $cmd = ['$project' => ['_id' => 0, 'firstName' => '$firstName', 'lastName' => '$lastName', 'id' => '$id'], '$limit' => 100];
    $response = $db->queryMDB("attend.users", $filter, $options, $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "get/statistic/partner") {
    //print_r("teszt");
    $data = $inputData;
    $data = changeStringToInt($data);
    //print_r($data);
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex('^' . $data['name'], 'i');
        $filter = ['companyName' => $regex];
    } else {
        $filter = [];
    }
    //print_r($filter);
    $options = [];
    $cmd = ['$project' => ['_id' => 0], '$limit' => 20];
    $response = $db->queryMDB("attend.partners", $filter, $options, $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "get/statistic/product") {
    //print_r("teszt");
    $data = $inputData;
    $data = changeStringToInt($data);
    //print_r($data);
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex('^' . $data['name'], 'i');
        $filter = ['productName' => $regex];
    } else {
        $filter = [];
    }
    //print_r($filter);
    $options = [];
    $cmd = ['$project' => ['_id' => 0], '$limit' => 20];
    $response = $db->queryMDB("attend.products", $filter, $options, $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "old/get/statistic/salesperson") {
    $data = $inputData;
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex($data['name'], 'i');
        $filter = ['salesPerson' => $regex];
    } else {
        $filter = [];
    }
    $cmd = [
        '$group' => [
            '_id' => [
                'salesPerson' => '$salesPerson'
            ]
        ],
        '$project' => [
            '_id' => 0,
            'salesPerson' => '$_id.salesPerson'
        ],
        '$sort' => [
            'salesPerson' => 1
        ]
    ];
    $response = $db->queryMDB("attend.oldsales", $filter, [], $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "old/get/statistic/partner") {
    $data = $inputData;
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex($data['name'], 'i');
        $filter = ['companyName' => $regex];
    } else {
        $filter = [];
    }
    $cmd = [
        '$group' => [
            '_id' => [
                'companyName' => '$companyName'
            ]
        ],
        '$project' => [
            '_id' => 0,
            'companyName' => '$_id.companyName'
        ],
        '$sort' => [
            'companyName' => 1
        ]
    ];
    $response = $db->queryMDB("attend.oldsales", $filter, [], $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "old/get/statistic/product") {
    $data = $inputData;
    if (isset($data['name'])) {
        $regex = new MongoDB\BSON\Regex($data['name'], 'i');
        $filter = ['productName' => $regex];
    } else {
        $filter = [];
    }
    $cmd = [
        '$group' => [
            '_id' => [
                'productName' => '$productName'
            ]
        ],
        '$project' => [
            '_id' => 0,
            'productName' => '$_id.productName'
        ],
        '$sort' => [
            'productName' => 1
        ]
    ];
    $response = $db->queryMDB("attend.oldsales", $filter, [], $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
} else if ($requestUri == "old/get/statistic") {
    $data = $inputData;
    $cmd = [];
    if (isset($data['filterproduct'])) {
        $cmd[] = [
            '$match' => [
                '$expr' => [
                    '$in' => ['$productName', $data['filterproduct']]
                ]
            ]
        ];
    }
    if (isset($data['filtersalesperson'])) {
        $cmd[] = [
            '$match' => [
                '$expr' => [
                    '$in' => ['$salesPerson', $data['filtersalesperson']]
                ]
            ]
        ];
    }
    if (isset($data['filterpartner'])) {
        $cmd[] = [
            '$match' => [
                '$expr' => [
                    '$in' => ['$companyName', $data['filterpartner']]
                ]
            ]
        ];
    }
    $cmd[] = [
        '$addFields' => [
            'splitDate' => [
                '$dateToParts' => [
                    'date' => [
                        '$toDate' => '$orderDate'
                    ]
                ]
            ]
        ]
    ];
    if (isset($data['filterdaterange'])) {
        $range = explode(' - ', $data['filterdaterange']);
        $cmd[] = [
            '$match' => [
                '$expr' => [
                    '$and' => [
                        [
                            '$gte' => [
                                [
                                    '$toDate' => '$orderDate'
                                ], [
                                    '$toDate' => $range[0]
                                ]
                            ]
                        ], [
                            '$lte' => [
                                [
                                    '$toDate' => '$orderDate'
                                ], [
                                    '$toDate' => $range[1]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];
    }
    $cols = [];
    if (isset($inputData['cols']) && $inputData['cols'] != []) {
        foreach ($inputData['cols'] as $c) {
            switch ($c) {
                case 'salesperson':
                    $cols[$c] = '$salesPerson';
                    break;
                case 'partner':
                    $cols[$c] = '$companyName';
                    break;
                case 'product':
                    $cols[$c] = '$productName';
                    break;
                case 'order':
                    $cols[$c] = '$id';
                    break;
                case 'year':
                    $cols[$c] = '$splitDate.year';
                    break;
                case 'month':
                    $cols[$c] = '$splitDate.month';
                    break;
                case 'day':
                    $cols[$c] = '$splitDate.day';
                    break;
            }
        }
        $cmd[] = [
            '$group' => [
                '_id' => $cols,
                'salesperson' => [
                    '$first' => '$salesPerson'
                ],
                'product' => [
                    '$first' => '$productName'
                ],
                'quantity' => [
                    '$sum' => '$quantitySum'
                ],
                'orderhead' => [
                    '$first' => '$orderNum'
                ],
                'partner' => [
                    '$first' => '$companyName'
                ],
                'total' => [
                    '$sum' => '$total'
                ],
                'date' => [
                    '$first' => '$deliveryDate'
                ],
                'year' => [
                    '$first' => '$splitDate.year'
                ],
                'month' => [
                    '$first' => '$splitDate.month'
                ],
                'day' => [
                    '$first' => '$splitDate.day'
                ]
            ]
        ];
    } else {
        $cmd[] = [
            '$group' => [
                '_id' => ['salesperson' => '$salesPerson'],
                'salesperson' => [
                    '$first' => '$salesPerson'
                ],
                'product' => [
                    '$first' => '$productName'
                ],
                'quantity' => [
                    '$sum' => '$quantitySum'
                ],
                'orderhead' => [
                    '$first' => '$orderNum'
                ],
                'partner' => [
                    '$first' => '$companyName'
                ],
                'total' => [
                    '$sum' => '$total'
                ],
                'date' => [
                    '$first' => '$deliveryDate'
                ],
                'year' => [
                    '$first' => '$splitDate.year'
                ],
                'month' => [
                    '$first' => '$splitDate.month'
                ],
                'day' => [
                    '$first' => '$splitDate.day'
                ]
            ]
        ];
    }
    $response = $db->queryMDBV3("attend.oldsales", [], [], $cmd);
    //print_r($response);
    $response = iterator_to_array($response);
    $result = json_encode($response);
}
