<?php
//print_r($requestUri);
if ($requestUri == "get/checktoken") {
	$data = $inputData;
	$filter = ['token' => $data['econtoken']];
	$options = [];
	$result = $db->queryMDB('attend.users', $filter, $options);
	$isGood = iterator_to_array($result);
	if (count($isGood) == 1) {
		$validuntil = strtotime($isGood[0]->tokenValidUntil->toDateTime()->format('r'));
		if ($validuntil > time()) {
			$result = ['status' => 'ok'];
		} else {
			$result = ['errorcode' => "102"]; // lejárt	
		}
	} else {
		$result = ['errorcode' => "101"]; // hibás token
	}
	$result = json_encode($result);
} else if ($requestUri == "get/checklogin") {
	$data = $inputData;
	//$data = changeStringToInt($data);
	$filter = $data;
	$options = [];
	$result = $db->queryMDB('attend.users', $filter, $options);
	$isGood = iterator_to_array($result);
	//print_r($data);
	if (count($isGood) == 1) {
		$token = $db->enData(time());
		$validuntil = new MongoDB\BSON\UTCDateTime((strtotime("now +8 hour")) * 1000);
		$data = ['token' => $token, 'tokenValidUntil' => $validuntil];
		$filter = ['id' => $isGood[0]->id];
		$request = $db->updateMDB('attend.users', $filter, $data);
		//print_r($isGood);
		$result = ['status' => 'ok', 'token' => $token];
	} else {
		$result = ['errorcode' => "102"]; // hibás login
	}
	$result = json_encode($result);
} else if ($requestUri == "get/user") {
	$data = $inputData;
	//$data = changeStringToInt($data);
	if (isset($data['id'])) {
		$data['id'] = intval($data['id']);
	}
	$filter = $data;
	$result = $db->queryMDB('attend.users', $filter);
	$result = iterator_to_array($result);
	unset($result[0]->password);
	$result = json_encode($result);
} else if ($requestUri == "get/users") {
	$data = $inputData;
	//$data = changeStringToInt($data);
	if (isset($data['id'])) {
		$data['id'] = intval($data['id']);
	}
	$filter = $data;
	$cmd = [
		'$project' => [
			'_id' => 0,
			'password' => 0,
			'token' => 0,
			'lastLogin' => 0
		]
	];
	$result = $db->queryMDB('attend.users', $filter, [], $cmd);
	$result = iterator_to_array($result);
	unset($result[0]->password);
	$result = json_encode($result);
} else if ($requestUri == "get/user/name") {
	$data = $inputData;
	//$data = changeStringToInt($data);
	if (isset($data['id'])) {
		$data['id'] = intval($data['id']);
	}
	$filter = $data;
	$result = $db->queryMDB('attend.users', $filter,[],['$project'=>['_id'=>0,'firstName'=>1,'lastName'=>1]]);
	$result = iterator_to_array($result);
	$result = json_encode($result);
} else if ($requestUri == "get/user/exists") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = $data;
	$options = [];
	$result = $db->queryMDB('attend.users', $filter, $options);
	$result = iterator_to_array($result);
	//print_r($result);
	if (count($result) == 0) {
		$result = ['status' => "ok"];
	} else {
		$result = ['errorcode' => '201', 'errormsg' => 'No data']; // nincs ilyen adat
	}
	$result = json_encode($result);
} else if ($requestUri == "get/user/lastid") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = [];
	$options = [];
	$cmd = ['$sort' => ['id' => -1], '$limit' => 1, '$project' => ['_id' => 0, "id" => 1]];
	$result = $db->queryMDB('attend.users', $filter, $options, $cmd);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = [['id' => -1]];
		$result = json_encode($result);
	} else {
		$result = json_encode($result);
	}
} else if ($requestUri == "get/partner/exists") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = $data;
	$options = [];
	$result = $db->queryMDB('attend.partners', $filter, $options);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = ['status' => "ok"];
	} else {
		$result = ['errorcode' => '201', 'errormsg' => 'No data']; // nincs ilyen adat
	}
	$result = json_encode($result);
} else if ($requestUri == "get/partner/lastid") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = [];
	$options = [];
	$cmd = ['$sort' => ['id' => -1], '$limit' => 1, '$project' => ['_id' => 0, "id" => 1]];
	$result = $db->queryMDB('attend.partners', $filter, $options, $cmd);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = [['id' => -1]];
		$result = json_encode($result);
	} else {
		$result = json_encode($result);
	}
} else if ($requestUri == "get/partner") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);

	if (isset($data['filter'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['filter'], 'i');
		$filter = ['name' => $regex];
	} else {
		$filter = $data;
	}
	$access = $db->isValidHasAccess($clientToken,);
	if (is_array($access)) {
		$access = ($access && $access["accesslevel"] < 3) ? false : $access["user"];
		if ($access) {
			//print_r($access);
			$filter['companySales'] = $access["user"];
		}
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.partners", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/partner/short") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['filter'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['filter'], 'i');
		$filter = ['companyName' => $regex];
	} else {
		$filter = $data;
	}
	$access = $db->isValidHasAccess($clientToken, 3);
	if (is_array($access)) {
		$access = ($access["accesslevel"] < 3) ? $access : false;
		if ($access != false && $access["accesslevel"] != 0) {
			$filter['companySales'] = $access["user"];
		}
	}
	//print_r($access);
	$options = [];
	$cmd = ['$project' => ['_id' => 0], '$limit' => 5000];
	$response = $db->queryMDB("attend.getCompanyShortDataV2", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/partner/search") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['companyName'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['companyName'], 'i');
		$filter = ['companyName' => $regex];
	} else {
		$filter = $data;
	}
	$access = $db->isValidHasAccess($clientToken, 3);
	if (is_array($access)) {
		$access = ($access["accesslevel"] < 3) ? $access : false;
		if ($access != false && $access["accesslevel"] != 0) {
			$filter['companySales'] = $access["user"];
		}
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0, 'id' => 1, "companyName" => 1], '$limit' => 10];
	$response = $db->queryMDB("attend.partners", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/product/exists") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = $data;
	$options = [];
	$result = $db->queryMDB('attend.products', $filter, $options);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = ['status' => "ok"];
	} else {
		$result = ['errorcode' => '201', 'errormsg' => 'No data']; // nincs ilyen adat
	}
	$result = json_encode($result);
} else if ($requestUri == "get/product/lastid") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = [];
	$options = [];
	$cmd = ['$sort' => ['id' => -1], '$limit' => 1, '$project' => ['_id' => 0, "id" => 1]];
	$result = $db->queryMDB('attend.products', $filter, $options, $cmd);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = [['id' => -1]];
		$result = json_encode($result);
	} else {
		$result = json_encode($result);
	}
} else if ($requestUri == "get/product") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['productName'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['productName'], 'i');
		$filter = ['productName' => $regex];
	} else {
		$filter = $data;
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.products", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	//print_r($response);
	$result = json_encode(utf8ize($response));
	//print_r(json_last_error_msg());
	//print_r($result);
} else if ($requestUri == "get/product/frontend") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['productName'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['productName'], 'i');
		$filter = ['productName' => $regex];
	} else {
		$filter = $data;
	}
	$filter['productPrice'] = ['$exists' => true];
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.products", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/product/frontend/search") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	$priceRangeBool = false;
	$filter = [];
	//echo (!isset($data['pricerange'])||(isset($data['pricerange'])&&$data['pricerange']=="null"));
	if (isset($data['productName']) && (!isset($data['pricerange']) || (isset($data['pricerange']) && $data['pricerange'] == "null"))) {
		$regex = new MongoDB\BSON\Regex($data['productName'], 'i');
		$filter['productName'] = $regex;
	} else if (isset($data['productName']) && isset($data['pricerange']) && $data['pricerange'] != "null") {
		if ($data['productName'] != '') {
			$regex = new MongoDB\BSON\Regex($data['productName'], 'i');
			$filter['productName'] = $regex;
		}
		$priceRangeBool = true;
		$filter['pricerange.' . $data['pricerange']] = ['$exists' => true];
	} else if (!isset($data['productName']) && isset($data['pricerange']) && $data['pricerange'] != "null") {
		$priceRangeBool = true;
		$filter['pricerange.' . $data['pricerange']] = ['$exists' => true];
	} else {
		$filter = $data;
		//echo json_encode($filter,JSON_NUMERIC_CHECK);
		if (isset($filter['pricerange'])) {
			//echo json_encode($filter,JSON_NUMERIC_CHECK);
			unset($filter['pricerange']);
		}
		//echo json_encode($data,JSON_NUMERIC_CHECK);
	}
	$filter['productPrice'] = ['$exists' => true];
	if (isset($data['id'])) {
		$filter['id'] = $data['id'];
	}
	$options = [];
	if ($priceRangeBool) {
		$cmd = [
			'$addFields' => [
				'productPrice' => '$pricerange.' . $data['pricerange']
			], '$project' => ['_id' => 0],
			'$limit' => 10
		];
	} else {
		$cmd = ['$project' => ['_id' => 0], '$limit' => 10];
	}
	//echo json_encode($filter,JSON_NUMERIC_CHECK);
	$response = $db->queryMDB("attend.products", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/productcategory/exists") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = $data;
	$options = [];
	$result = $db->queryMDB('attend.productcategories', $filter, $options);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = ['status' => "ok"];
	} else {
		$result = ['errorcode' => '201', 'errormsg' => 'No data']; // nincs ilyen adat
	}
	$result = json_encode($result);
} else if ($requestUri == "get/productcategory/lastid") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = [];
	$options = [];
	$cmd = ['$sort' => ['id' => -1], '$limit' => 1, '$project' => ['_id' => 0, "id" => 1]];
	$result = $db->queryMDB('attend.productcategories', $filter, $options, $cmd);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = [['id' => -1]];
		$result = json_encode($result);
	} else {
		$result = json_encode($result);
	}
} else if ($requestUri == "get/productcategory") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['filter'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['filter'], 'i');
		$filter = ['name' => $regex];
	} else {
		$filter = [];
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.productcategories", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/cities") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['city'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['city'], 'i');
		$filter = [
			'$or' => [
				['city' => $regex],
				['zip' => ['$eq' => $data['city']]],
			]
		];
	} else {
		$filter = [];
	}
	$options = [];
	$cmd = ['$limit' => 25];
	$cmd = [];
	$response = $db->queryMDB("attend.cities", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/counties") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['name'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['name'], 'i');
		$filter = ['name' => $regex];
	} else {
		$filter = [];
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.counties", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/countries") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['filter'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['filter'], 'i');
		$filter = ['name' => $regex];
	} else {
		$filter = [];
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.countries", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/orders") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['filter'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['filter'], 'i');
		$filter = ['name' => $regex];
	} else {
		$filter = $data;
	}
	$access = $db->isValidHasAccess($clientToken, 3);
	if (is_array($access)) {
		$access = ($access && $access["accesslevel"] < 3) ? false : $access["user"];
		if ($access) {
			$filter['salesPerson'] = $access["user"];
		}
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0], '$sort' => ['id' => -1]];
	$response = $db->queryMDB("attend.fullorder", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/order/lastid") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = [];
	$options = [];
	$cmd = ['$sort' => ['id' => -1], '$limit' => 1, '$project' => ['_id' => 0, "id" => 1]];
	$result = $db->queryMDB('attend.orderhead', $filter, $options, $cmd);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = ['id' => 1];
		$result = json_encode($result);
	} else {
		$result = json_encode($result);
	}
} else if ($requestUri == "get/order/exists") {
	$data = $inputData;
	$data = changeStringToInt($data);
	$filter = $data;
	$options = [];
	$result = $db->queryMDB('attend.orderhead', $filter, $options);
	$result = iterator_to_array($result);
	if (count($result) == 0) {
		$result = ['status' => "ok"];
	} else {
		$result = ['errorcode' => '201', 'errormsg' => 'No data']; // nincs ilyen adat
	}
	$result = json_encode($result);
} else if ($requestUri == "get/orders/status") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['filter'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['filter'], 'i');
		$filter = ['name' => $regex];
	} else {
		$filter = $data;
	}
	$access = $db->isValidHasAccess($clientToken, 2);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.getOrderStatusView", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "v2/get/orders/status") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	$access = $db->isValidHasAccess($clientToken, 2);
	$options = [];
	if (isset($data['filter'])) {
		$cmd = [
			[
				'$match' => [
					'$and' => [
						[
							'status' => [
								'$eq' => $data['status']
							],'orderhead.orderAccept'=>[
								'$eq' => 2
							]
						], [
							'$or' => [
								[
									'productName' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'invoiceNum' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'ekaer' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'companyVat' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'companyName' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								]
							]
						]
					]
				]
			], ['$project' => ['_id' => 0]], ['$sort' => ['delivery' => 1, 'orderhead.id' => -1]]
		];
	} else {
		$cmd = [
			[
				'$match' => [
					'$and' => [
						[
							'status' => [
								'$eq' => $data['status']
							],'orderhead.orderAccept'=>[
								'$eq' => 2
							]
						]
					]
				]
			], ['$project' => ['_id' => 0]], ['$sort' => ['delivery' => 1, 'orderhead.id' => -1]]
		];
	}
	$response = $db->queryMDBV3("attend.getOrderStatusView", [], $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "v3/get/orders/status") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	$access = $db->isValidHasAccess($clientToken, 2);
	$options = [];
	if (isset($data['filter'])) {
		$cmd = [
			[
				'$match' => [
					'$and' => [
						[
							'status' => [
								'$eq' => $data['status']
							]
						], [
							'orderhead.salePerson' => [
								'$eq' => $data['sale']
							]
						], [
							'$or' => [
								[
									'productName' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'invoiceNum' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'ekaer' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'companyVat' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								], [
									'companyName' => [
										'$regex' => $data['filter'],
										'$options' => 'i'
									]
								]
							]
						]
					]
				]
			], ['$project' => ['_id' => 0]], ['$sort' => ['delivery' => 1, 'orderhead.id' => -1]]
		];
	} else {
		$cmd = [
			[
				'$match' => [
					'$and' => [
						[
							'status' => [
								'$eq' => $data['status']
							]
						], [
							'orderhead.salePerson' => [
								'$eq' => $data['sale']
							]
						]
					]
				]
			], ['$project' => ['_id' => 0]], ['$sort' => ['delivery' => 1, 'orderhead.id' => -1]]
		];
	}
	$response = $db->queryMDBV3("attend.getOrderStatusView", [], $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/priceranges") {
	//print_r("teszt");
	$data = $inputData;
	$data = changeStringToInt($data);
	//print_r($data);
	if (isset($data['filter'])) {
		$regex = new MongoDB\BSON\Regex('^' . $data['filter'], 'i');
		$filter = ['name' => $regex];
	} else {
		$filter = [];
	}
	//print_r($filter);
	$options = [];
	$cmd = ['$project' => ['_id' => 0]];
	$response = $db->queryMDB("attend.priceranges", $filter, $options, $cmd);
	//print_r($response);
	$response = iterator_to_array($response);
	$result = json_encode($response);
} else if ($requestUri == "get/commision") {
	$data = $inputData;
	$data = changeStringToInt($data);
	if (isset($data['id'])) {
		$cmd = [
			[
				'$match' => [
					'salesPerson' => $data['id']
				]
			]
		];
	} else {
		$cmd = [];
	}
	$cmd2 = [
		[
			'$lookup' => [
				'from' => 'orderbody',
				'let' => [
					'oh' => '$id'
				],
				'pipeline' => [
					[
						'$match' => [
							'$expr' => [
								'$and' => [
									[
										'$eq' => [
											'$orderhead', '$$oh'
										]
									], [
										'$eq' => [
											'$status', 4
										]
									]
								]
							]
						]
					], [
						'$addFields' => [
							'commission' => [
								'$multiply' => [
									'$total', '$productComission', 0.01
								]
							],
							'commissionKata' => [
								'$multiply' => [
									'$total', '$productComissionKata', 0.01
								]
							]
						]
					]
				],
				'as' => 'items'
			]
		], [
			'$unwind' => [
				'path' => '$items',
				'preserveNullAndEmptyArrays' => False
			]
		], [
			'$group' => [
				'_id' => [
					'salesPerson' => '$salesPerson'
				],
				'order' => [
					'$addToSet' => '$items'
				],
				'commission' => [
					'$sum' => '$items.commission'
				],
				'commissionKata' => [
					'$sum' => '$items.commissionKata'
				]
			]
		], [
			'$lookup' => [
				'from' => 'users',
				'let' => [
					'sid' => '$_id.salesPerson'
				],
				'pipeline' => [
					[
						'$match' => [
							'$expr' => [
								'$and' => [
									[
										'$eq' => [
											'$id', '$$sid'
										]
									]
								]
							]
						]
					], [
						'$project' => [
							'firstName' => '$firstName',
							'lastName' => '$lastName',
							'userTax' => '$userTax',
							'userID' => '$id'
						]
					]
				],
				'as' => 'salesPerson'
			]
		], [
			'$unwind' => [
				'path' => '$salesPerson',
				'preserveNullAndEmptyArrays' => False
			]
		]
	];
	$cmd = array_merge($cmd, $cmd2);
	$response = $db->queryMDBV3("attend.orderhead", [], [], $cmd);
	$response = $response->toArray();
	$result = json_encode($response);
} else if ($requestUri == "get/commision/daterange") {
	$data = $inputData;
	$data = changeStringToInt($data);
	if (isset($data['id'])) {
		if (isset($data['daterange'])) {
			$range = explode(" - ", $data['daterange']);
			$range[0] = date("m/d/Y", strtotime($range[0]));
			$range[1] = date("m/d/Y", strtotime($range[1]));
			$cmd = [
				[
					'$match' => [
						'salesPerson' => $data['id'],
						'paymentDueDate' => ['$lt' => $range[1]],
						'paymentDueDate' => ['$gt' => $range[0]]
					]
				]
			];
		} else {
			$cmd = [
				[
					'$match' => [
						'salesPerson' => $data['id']
					]
				]
			];
		}
	} else {
		$cmd = [];
	}
	$cmd2 = [
		[
			'$lookup' => [
				'from' => 'orderbody',
				'let' => [
					'oh' => '$id',
					'cname' => '$customer.companyName'
				],
				'pipeline' => [
					[
						'$match' => [
							'$expr' => [
								'$and' => [
									[
										'$eq' => [
											'$orderhead', '$$oh'
										]
									], [
										'$eq' => [
											'$status', 4
										]
									]
								]
							]
						]
					], [
						'$addFields' => [
							'commission' => [
								'$multiply' => [
									'$total', '$productComission', 0.01
								]
							],
							'commissionKata' => [
								'$multiply' => [
									'$total', '$productComissionKata', 0.01
								]
							],
							'companyName' => '$$cname'
						]
					]
				],
				'as' => 'items'
			]
		], [
			'$unwind' => [
				'path' => '$items',
				'preserveNullAndEmptyArrays' => False
			]
		], [
			'$group' => [
				'_id' => [
					'salesPerson' => '$salesPerson'
				],
				'order' => [
					'$addToSet' => '$items'
				],
				'commission' => [
					'$sum' => '$items.commission'
				],
				'commissionKata' => [
					'$sum' => '$items.commissionKata'
				]
			]
		], [
			'$lookup' => [
				'from' => 'users',
				'let' => [
					'sid' => '$_id.salesPerson'
				],
				'pipeline' => [
					[
						'$match' => [
							'$expr' => [
								'$and' => [
									[
										'$eq' => [
											'$id', '$$sid'
										]
									]
								]
							]
						]
					], [
						'$project' => [
							'firstName' => '$firstName',
							'lastName' => '$lastName',
							'userTax' => '$userTax',
							'userID' => '$id'
						]
					]
				],
				'as' => 'salesPerson'
			]
		], [
			'$unwind' => [
				'path' => '$salesPerson',
				'preserveNullAndEmptyArrays' => False
			]
		], [
			'$addFields' => [
				'final' => [
					'$cond' => [
						[
							'$or' => [
								['$eq' => ['$salesPerson.userTax', "0"]],
								['$eq' => ['$salesPerson.userTax', "3"]]
							]
						], '$commissionKata', '$commission'
					]
				]
			]
		]/**/
	];
	$cmd = array_merge($cmd, $cmd2);
	$response = $db->queryMDBV3("attend.orderhead", [], [], $cmd);
	$response = $response->toArray();
	$result = json_encode($response);
}
